/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Catalog;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

@Singleton
public class OrgNameCatalogNameItemNameToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Catalog>>> orgCatalogMap;
    private final ReferenceType defaultOrg;
    private final ReferenceType defaultCatalog;

    @Inject
    public OrgNameCatalogNameItemNameToEndpoint(Supplier<Map<String, Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Catalog>>> orgCatalogMap, @Org ReferenceType defaultOrg, @Catalog ReferenceType defaultCatalog) {
        this.orgCatalogMap = orgCatalogMap;
        this.defaultOrg = defaultOrg;
        this.defaultCatalog = defaultCatalog;
    }

    @Override
    public URI apply(Object from) {
        Iterable orgCatalog = (Iterable)Preconditions.checkNotNull(from, "args");
        Object org = Iterables.get(orgCatalog, 0);
        Object catalog = Iterables.get(orgCatalog, 1);
        Object catalogItem = Iterables.get(orgCatalog, 2);
        if (org == null) {
            org = this.defaultOrg.getName();
        }
        if (catalog == null) {
            catalog = this.defaultCatalog.getName();
        }
        try {
            Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Catalog> catalogs = Preconditions.checkNotNull(this.orgCatalogMap.get().get(org));
            return ((ReferenceType)catalogs.get(catalog).get(catalogItem)).getHref();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + "/" + catalog + "/" + catalogItem + " not found in " + this.orgCatalogMap.get());
        }
    }
}

