/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.Org;

@Singleton
public class OrgsForLocations
implements Function<Iterable<? extends Location>, Iterable<? extends Org>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    OrgsForLocations(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    @Override
    public Iterable<? extends Org> apply(Iterable<? extends Location> from) {
        return FutureIterables.transformParallel(Sets.newLinkedHashSet(Iterables.transform(Iterables.filter(from, new Predicate<Location>(){

            @Override
            public boolean apply(Location input) {
                return input.getScope() == LocationScope.ZONE;
            }
        }), new Function<Location, URI>(){

            @Override
            public URI apply(Location from) {
                return URI.create(from.getParent().getId());
            }
        })), new Function<URI, Future<Org>>(){

            @Override
            public Future<Org> apply(URI from) {
                return OrgsForLocations.this.aclient.getOrg(from);
            }
        }, this.executor, null, this.logger, "organizations for uris");
    }
}

