/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.Org;

@Singleton
public class OrgsForNames
implements Function<Iterable<String>, Iterable<? extends Org>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    OrgsForNames(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    @Override
    public Iterable<? extends Org> apply(Iterable<String> from) {
        return FutureIterables.transformParallel(from, new Function<String, Future<Org>>(){

            @Override
            public Future<Org> apply(String from) {
                return OrgsForNames.this.aclient.findOrgNamed(from);
            }
        }, this.executor, null, this.logger, "organizations for names");
    }
}

