/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.handlers;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;

@Singleton
public class ParseTerremarkVCloudErrorFromHttpResponse
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final Pattern RESOURCE_PATTERN = Pattern.compile(".*/v[^/]+/([^/]+)/([0-9]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        void var3_13;
        block13: {
            HttpResponseException httpResponseException = new HttpResponseException(command, response);
            try {
                void var3_5;
                String content = this.parseErrorFromContentOrNull(command, response);
                if (content != null) {
                    HttpResponseException httpResponseException2 = new HttpResponseException(command, response, content);
                }
                if (response.getMessage() != null && (response.getMessage().indexOf("because there is a pending task running") != -1 || response.getMessage().indexOf("because it is already powered off") != -1 || response.getMessage().indexOf("exists") != -1)) {
                    IllegalStateException illegalStateException = new IllegalStateException(response.getMessage(), (Throwable)var3_5);
                    break block13;
                }
                if (response.getMessage() != null && response.getMessage().indexOf("There are no additional Public IPs available") != -1) {
                    InsufficientResourcesException insufficientResourcesException = new InsufficientResourcesException(response.getMessage(), (Throwable)var3_5);
                } else {
                    switch (response.getStatusCode()) {
                        case 400: {
                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(response.getMessage(), (Throwable)var3_5);
                            break;
                        }
                        case 401: {
                            AuthorizationException authorizationException = new AuthorizationException(var3_5.getMessage(), (Throwable)var3_5);
                            break;
                        }
                        case 403: 
                        case 404: {
                            String path = command.getCurrentRequest().getEndpoint().getPath();
                            Matcher matcher = RESOURCE_PATTERN.matcher(path);
                            String message = matcher.find() ? String.format("%s %s not found", matcher.group(1), matcher.group(2)) : path;
                            ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)var3_5);
                            break;
                        }
                        case 405: {
                            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(response.getMessage(), (Throwable)var3_5);
                            break;
                        }
                        case 501: {
                            if (response.getMessage() == null || response.getMessage().indexOf("NotImplemented") == -1) break;
                            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(response.getMessage(), (Throwable)var3_5);
                            break;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                HttpUtils.releasePayload(response);
                command.setException(httpResponseException);
                throw throwable;
            }
        }
        HttpUtils.releasePayload(response);
        command.setException((Exception)var3_13);
    }

    String parseErrorFromContentOrNull(HttpCommand command, HttpResponse response) {
        if (response.getPayload() != null) {
            try {
                return Strings2.toStringAndClose(response.getPayload().getInput());
            }
            catch (IOException e) {
                this.logger.warn(e, "exception reading error from response", response);
            }
        }
        return null;
    }
}

