/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.options;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.trmk.vcloud_0_8.binders.BindAddInternetServiceToXmlPayload;

public class AddInternetServiceOptions
extends BindAddInternetServiceToXmlPayload {
    @VisibleForTesting
    String description = null;
    @VisibleForTesting
    String enabled = "true";
    @VisibleForTesting
    Boolean monitorEnabled = null;

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        ImmutableMap.Builder<String, String> copy = ImmutableMap.builder();
        copy.putAll(postParams);
        if (this.description != null) {
            copy.put("description", this.description);
        }
        copy.put("enabled", this.enabled);
        if (this.monitorEnabled != null) {
            copy.put("monitor", this.monitorEnabled.toString());
        }
        return super.bindToRequest(request, copy.build());
    }

    public AddInternetServiceOptions disabled() {
        this.enabled = "false";
        return this;
    }

    public AddInternetServiceOptions monitorDisabled() {
        this.monitorEnabled = false;
        return this;
    }

    public AddInternetServiceOptions withDescription(String description) {
        this.description = description;
        return this;
    }

    public static class Builder {
        public static AddInternetServiceOptions withDescription(String description) {
            AddInternetServiceOptions options = new AddInternetServiceOptions();
            return options.withDescription(description);
        }

        public static AddInternetServiceOptions monitorDisabled() {
            AddInternetServiceOptions options = new AddInternetServiceOptions();
            return options.monitorDisabled();
        }

        public static AddInternetServiceOptions disabled() {
            AddInternetServiceOptions options = new AddInternetServiceOptions();
            return options.disabled();
        }
    }
}

