/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.SortedMap;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.internal.CatalogItemImpl;
import org.jclouds.trmk.vcloud_0_8.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CatalogItemHandler
extends ParseSax.HandlerWithResult<CatalogItem> {
    private StringBuilder currentText = new StringBuilder();
    protected ReferenceType catalogItem;
    protected ReferenceType entity;
    protected String description;
    protected String key;
    protected SortedMap<String, String> properties = Maps.newTreeMap();
    private ReferenceType customizationOptions;
    private ReferenceType computeOptions;

    @Override
    public CatalogItem getResult() {
        return new CatalogItemImpl(this.catalogItem.getName(), this.catalogItem.getHref(), this.description, this.computeOptions, this.customizationOptions, this.entity, this.properties);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.equals("CatalogItem")) {
            this.catalogItem = Utils.newReferenceType(attributes);
        } else if (qName.equals("Entity")) {
            this.entity = Utils.newReferenceType(attributes);
        } else if (qName.equals("Property")) {
            this.key = attributes.get("key");
        } else if (qName.equals("Link") && attributes.containsKey("name")) {
            if (attributes.get("name").equals("Customization Options")) {
                this.customizationOptions = Utils.newReferenceType(attributes);
            } else if (attributes.get("name").equals("Compute Options")) {
                this.computeOptions = Utils.newReferenceType(attributes);
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Description")) {
            this.description = this.currentOrNull();
        } else if (qName.equals("Property")) {
            this.properties.put(this.key, this.currentOrNull());
            this.key = null;
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

