/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.NetworkAdapter;
import org.jclouds.trmk.vcloud_0_8.domain.Subnet;
import org.jclouds.trmk.vcloud_0_8.domain.VAppExtendedInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VAppExtendedInfoHandler
extends ParseSax.HandlerWithResult<VAppExtendedInfo> {
    @Resource
    protected Logger logger = Logger.NULL;
    private StringBuilder currentText = new StringBuilder();
    private String id;
    private URI href;
    private String name;
    private String longName;
    private List<String> tags;
    private List<NetworkAdapter> networkAdapters = Lists.newArrayList();
    private boolean inAdapters;
    private String macAddress;
    private String adapterName;
    private boolean inSubnet;
    private Subnet subnet;
    private URI subnetLocation;
    private String subnetName;

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }

    @Override
    public VAppExtendedInfo getResult() {
        return new VAppExtendedInfo(this.id, this.href, this.name, this.tags, this.longName, this.networkAdapters);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("NetworkAdapters")) {
            this.inAdapters = true;
        } else if (qName.equals("Subnet")) {
            this.inSubnet = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        String current = this.currentOrNull();
        if (current != null) {
            if (qName.equals("Id")) {
                this.id = current;
            } else if (qName.equals("Tags")) {
                this.tags = Arrays.asList(current.split(","));
            } else if (qName.equals("LongName")) {
                this.longName = current;
            } else if (qName.equals("Href")) {
                if (this.inSubnet) {
                    this.subnetLocation = URI.create(current);
                } else {
                    this.href = URI.create(current);
                }
            } else if (qName.equals("Name")) {
                if (this.inSubnet) {
                    this.subnetName = current;
                } else if (this.inAdapters) {
                    this.adapterName = current;
                } else {
                    this.name = current;
                }
            } else if (qName.equals("NetworkAdapters")) {
                this.inAdapters = false;
            } else if (qName.equals("NetworkAdapter")) {
                this.networkAdapters.add(new NetworkAdapter(this.macAddress, this.adapterName, this.subnet));
                this.macAddress = null;
                this.adapterName = null;
                this.subnet = null;
            } else if (qName.equals("MacAddress")) {
                this.macAddress = current;
            } else if (qName.equals("Subnet")) {
                this.subnet = new Subnet(this.subnetLocation, this.subnetName);
                this.subnetLocation = null;
                this.subnetName = null;
                this.inSubnet = false;
            }
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

