/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.VirtualSystemSettingData;
import org.jclouds.cim.xml.ResourceAllocationSettingDataHandler;
import org.jclouds.cim.xml.VirtualSystemSettingDataHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.domain.internal.VAppImpl;
import org.jclouds.trmk.vcloud_0_8.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VAppHandler
extends ParseSax.HandlerWithResult<VApp> {
    private final VirtualSystemSettingDataHandler systemHandler;
    private final ResourceAllocationSettingDataHandler allocationHandler;
    @Resource
    protected Logger logger = Logger.NULL;
    protected VirtualSystemSettingData system;
    protected Set<ResourceAllocationSettingData> allocations = Sets.newLinkedHashSet();
    protected Status status;
    protected final ListMultimap<String, String> networkToAddresses = ArrayListMultimap.create();
    protected StringBuilder currentText = new StringBuilder();
    protected String operatingSystemDescription;
    protected boolean inOs;
    protected String networkName;
    protected String name;
    protected Integer osType;
    protected URI location;
    protected Long size;
    protected ReferenceType vDC;
    protected Set<ReferenceType> extendedInfo = Sets.newLinkedHashSet();

    @Inject
    public VAppHandler(VirtualSystemSettingDataHandler systemHandler, ResourceAllocationSettingDataHandler allocationHandler) {
        this.systemHandler = systemHandler;
        this.allocationHandler = allocationHandler;
    }

    @Override
    public VApp getResult() {
        return new VAppImpl(this.name, this.location, this.status, this.size, this.vDC, this.networkToAddresses, this.osType, this.operatingSystemDescription, this.system, this.allocations, this.extendedInfo);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.equals("VApp")) {
            ReferenceType resource = Utils.newReferenceType(attributes);
            this.name = resource.getName();
            this.location = resource.getHref();
            String statusString = attributes.get("status");
            this.status = Status.fromValue(statusString);
            if (attributes.containsKey("size")) {
                this.size = new Long(attributes.get("size"));
            }
        } else if (qName.equals("Link")) {
            if (attributes.containsKey("type")) {
                if (attributes.get("type").equals("application/vnd.vmware.vcloud.vdc+xml")) {
                    this.vDC = Utils.newReferenceType(attributes);
                } else {
                    this.extendedInfo.add(Utils.newReferenceType(attributes));
                }
            }
        } else if (qName.equals("OperatingSystemSection")) {
            this.inOs = true;
            if (attributes.containsKey("id")) {
                this.osType = Integer.parseInt(attributes.get("id"));
            }
        } else if (qName.endsWith("NetworkConnection")) {
            this.networkName = attributes.get("Network");
        } else {
            this.systemHandler.startElement(uri, localName, qName, attrs);
            this.allocationHandler.startElement(uri, localName, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("OperatingSystemSection")) {
            this.inOs = false;
        } else if (this.inOs && qName.equals("Description")) {
            this.operatingSystemDescription = this.currentText.toString().trim();
        } else if (qName.endsWith("IpAddress")) {
            this.networkToAddresses.put(this.networkName, this.currentText.toString().trim());
        } else if (qName.equals("System")) {
            this.systemHandler.endElement(uri, localName, qName);
            this.system = this.systemHandler.getResult();
        } else if (qName.equals("Item")) {
            this.allocationHandler.endElement(uri, localName, qName);
            this.allocations.add(this.allocationHandler.getResult());
        } else {
            this.systemHandler.endElement(uri, localName, qName);
            this.allocationHandler.endElement(uri, localName, qName);
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
        this.systemHandler.characters(ch, start, length);
        this.allocationHandler.characters(ch, start, length);
    }
}

