/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloudexpress.suppliers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.InternetService;
import org.jclouds.trmk.vcloud_0_8.domain.Protocol;
import org.jclouds.trmk.vcloud_0_8.domain.PublicIpAddress;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.options.AddInternetServiceOptions;
import org.jclouds.trmk.vcloud_0_8.suppliers.InternetServiceAndPublicIpAddressSupplier;
import org.jclouds.trmk.vcloudexpress.TerremarkVCloudExpressClient;

@Singleton
public class TerremarkVCloudExpressInternetServiceAndPublicIpAddressSupplier
implements InternetServiceAndPublicIpAddressSupplier {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    protected final TerremarkVCloudExpressClient client;

    @Inject
    public TerremarkVCloudExpressInternetServiceAndPublicIpAddressSupplier(TerremarkVCloudExpressClient client) {
        this.client = client;
    }

    @Override
    public Map.Entry<InternetService, PublicIpAddress> getNewInternetServiceAndIp(VApp vApp, int port, Protocol protocol) {
        this.logger.debug(">> creating InternetService in vDC %s:%s:%d", new Object[]{vApp.getVDC().getHref(), protocol, port});
        InternetService is = this.client.addInternetServiceToVDC(vApp.getVDC().getHref(), vApp.getName() + "-" + port, protocol, port, AddInternetServiceOptions.Builder.withDescription(String.format("port %d access to serverId: %s name: %s", port, vApp.getName(), vApp.getName())));
        PublicIpAddress ip = is.getPublicIpAddress();
        ImmutableMap<InternetService, PublicIpAddress> result = ImmutableMap.of(is, ip);
        Map.Entry<InternetService, PublicIpAddress> entry = Iterables.getOnlyElement(result.entrySet());
        return entry;
    }
}

