/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.jclouds.logging.Logger;
import org.jclouds.util.Patterns;

public class Strings2 {
    public static final String UTF8_ENCODING = "UTF-8";
    @Resource
    private static Logger logger = Logger.NULL;

    public static String urlEncode(String in, char ... skipEncode) {
        if (Strings2.isUrlEncoded(in)) {
            return in;
        }
        try {
            String returnVal = URLEncoder.encode(in, UTF8_ENCODING);
            returnVal = Strings2.replaceAll(returnVal, '+', Patterns.PLUS_PATTERN, "%20");
            returnVal = Strings2.replaceAll(returnVal, '*', Patterns.STAR_PATTERN, "%2A");
            returnVal = Strings2.replaceAll(returnVal, Patterns._7E_PATTERN, "~");
            for (char c : skipEncode) {
                returnVal = Strings2.replaceAll(returnVal, Patterns.CHAR_TO_ENCODED_PATTERN.get(Character.valueOf(c)), c + "");
            }
            return returnVal;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Bad encoding on input: " + in, e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("error creating pattern: " + in, e);
        }
    }

    public static boolean isUrlEncoded(String in) {
        return Patterns.URL_ENCODED_PATTERN.matcher(in).matches();
    }

    public static String urlDecode(String in) {
        try {
            return URLDecoder.decode(in, UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Bad encoding on input: " + in, e);
        }
    }

    public static String replaceTokens(String value, Iterable<Map.Entry<String, String>> tokenValues) {
        for (Map.Entry<String, String> tokenValue : tokenValues) {
            try {
                value = Strings2.replaceAll(value, Patterns.TOKEN_TO_PATTERN.get(tokenValue.getKey()), tokenValue.getValue());
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("error creating pattern: " + tokenValue.getKey(), e);
            }
        }
        return value;
    }

    public static String replaceAll(String returnVal, Pattern pattern, String replace) {
        Matcher m = pattern.matcher(returnVal);
        returnVal = m.replaceAll(replace);
        return returnVal;
    }

    public static String replaceAll(String input, char ifMatch, Pattern pattern, String replacement) {
        if (input.indexOf(ifMatch) != -1) {
            input = pattern.matcher(input).replaceAll(replacement);
        }
        return input;
    }

    public static String replaceAll(String input, char match, String replacement) {
        if (input.indexOf(match) != -1) {
            try {
                input = Patterns.CHAR_TO_PATTERN.get(Character.valueOf(match)).matcher(input).replaceAll(replacement);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("error creating pattern: " + match, e);
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toStringAndClose(InputStream input) throws IOException {
        Preconditions.checkNotNull(input, "input");
        try {
            String string = new String(ByteStreams.toByteArray(input), Charsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            logger.warn(e, "Failed to read from stream", new Object[0]);
            String string = null;
            return string;
        }
        catch (NullPointerException e) {
            String string = null;
            return string;
        }
        finally {
            Closeables.closeQuietly(input);
        }
    }

    public static InputStream toInputStream(String in) {
        return new ByteArrayInputStream(in.getBytes(Charsets.UTF_8));
    }

    public static byte[] encodeString(String str, String charsetName) {
        try {
            return str.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn(e, "Failed to encode string to bytes with encoding " + charsetName + ". Falling back to system's default encoding", new Object[0]);
            return str.getBytes();
        }
    }

    public static byte[] encodeString(String str) {
        return Strings2.encodeString(str, UTF8_ENCODING);
    }

    public static String replaceTokens(String input, Map<String, String> replacements) {
        Matcher matcher = Patterns.TOKEN_PATTERN.matcher(input);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            builder.append(input.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(input.substring(i, input.length()));
        return builder.toString();
    }
}

