/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.inject.CreationException;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import java.util.NoSuchElementException;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;

public class Throwables2 {
    public static <T extends Throwable> T getFirstThrowableOfType(Throwable from, Class<T> clazz) {
        if (from instanceof ProvisionException) {
            return Throwables2.getFirstThrowableOfType((ProvisionException)ProvisionException.class.cast(from), clazz);
        }
        if (from instanceof CreationException) {
            return Throwables2.getFirstThrowableOfType((CreationException)CreationException.class.cast(from), clazz);
        }
        try {
            return (T)((Throwable)Iterables.find(Throwables.getCausalChain(from), Predicates.instanceOf(clazz)));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public static <T extends Throwable> T getFirstThrowableOfType(ProvisionException e, Class<T> clazz) {
        for (Message message : e.getErrorMessages()) {
            if (message.getCause() == null) continue;
            T cause = Throwables2.getFirstThrowableOfType(message.getCause(), clazz);
            if (cause instanceof ProvisionException) {
                return Throwables2.getFirstThrowableOfType((ProvisionException)ProvisionException.class.cast(cause), clazz);
            }
            if (cause instanceof CreationException) {
                return Throwables2.getFirstThrowableOfType((CreationException)CreationException.class.cast(cause), clazz);
            }
            return cause;
        }
        return null;
    }

    public static <T extends Throwable> T getFirstThrowableOfType(CreationException e, Class<T> clazz) {
        for (Message message : e.getErrorMessages()) {
            if (message.getCause() == null) continue;
            T cause = Throwables2.getFirstThrowableOfType(message.getCause(), clazz);
            if (cause instanceof ProvisionException) {
                return Throwables2.getFirstThrowableOfType((ProvisionException)ProvisionException.class.cast(cause), clazz);
            }
            if (cause instanceof CreationException) {
                return Throwables2.getFirstThrowableOfType((CreationException)CreationException.class.cast(cause), clazz);
            }
            return cause;
        }
        return null;
    }

    public static <T> T propagateOrNull(Exception from) {
        Throwables.propagate(from);
        assert (false) : "exception should have propogated";
        return null;
    }

    public static Exception returnFirstExceptionIfInListOrThrowStandardExceptionOrCause(Class[] exceptionTypes, Exception exception) throws Exception {
        Object throwable;
        for (Class type : exceptionTypes) {
            throwable = Throwables2.getFirstThrowableOfType(exception, type);
            if (throwable == null) continue;
            return (Exception)throwable;
        }
        for (Class propagatableExceptionType : new Class[]{IllegalStateException.class, AssertionError.class, UnsupportedOperationException.class, IllegalArgumentException.class, AuthorizationException.class, ResourceNotFoundException.class, InsufficientResourcesException.class, HttpResponseException.class}) {
            throwable = Throwables2.getFirstThrowableOfType(exception, propagatableExceptionType);
            if (throwable == null) continue;
            if (throwable instanceof AssertionError) {
                throw (AssertionError)throwable;
            }
            throw (Exception)throwable;
        }
        Throwables.propagateIfPossible(exception.getCause(), Exception.class);
        throw exception;
    }

    public static <T> T propagateAuthorizationOrOriginalException(Exception e) {
        AuthorizationException aex = Throwables2.getFirstThrowableOfType(e, AuthorizationException.class);
        if (aex != null) {
            throw aex;
        }
        Throwables.propagate(e);
        assert (false) : "exception should have propogated " + e;
        return null;
    }
}

