/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.options.CloneOptions;

@Singleton
public abstract class BindCloneParamsToXmlPayload<O extends CloneOptions>
implements MapBinder {
    protected final String ns;
    protected final String schema;
    private final BindToStringPayload stringBinder;

    protected abstract String getRootElement();

    protected abstract String getSourceMediaType();

    protected abstract Class<O> getOptionClass();

    @Inject
    public BindCloneParamsToXmlPayload(BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema) {
        this.ns = ns;
        this.schema = schema;
        this.stringBinder = stringBinder;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState(gRequest.getArgs() != null, "args should be initialized at this point");
        String name = Preconditions.checkNotNull(postParams.get("name"), "name");
        String source = Preconditions.checkNotNull(postParams.get("Source"), "Source");
        boolean isSourceDelete = Boolean.parseBoolean(postParams.get("IsSourceDelete"));
        O options = this.findOptionsInArgsOrNew(gRequest);
        return this.stringBinder.bindToRequest(request, this.generateXml(name, source, isSourceDelete, options));
    }

    protected String generateXml(String name, String source, boolean isSourceDelete, O options) {
        XMLBuilder rootBuilder = this.buildRoot(name, options);
        this.addElementsUnderRoot(rootBuilder, source, options, isSourceDelete);
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        try {
            return rootBuilder.asString(outputProperties);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    protected void addElementsUnderRoot(XMLBuilder rootBuilder, String source, O options, boolean isSourceDelete) {
        if (((CloneOptions)options).getDescription() != null) {
            rootBuilder.e("Description").text(((CloneOptions)options).getDescription());
        }
        rootBuilder.e("Source").a("href", source).a("type", this.getSourceMediaType());
        if (isSourceDelete) {
            rootBuilder.e("IsSourceDelete").t("true");
        }
    }

    protected XMLBuilder buildRoot(String name, O options) {
        try {
            return XMLBuilder.create(this.getRootElement()).a("xmlns", this.ns).a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").a("xsi:schemaLocation", this.ns + " " + this.schema).a("name", name);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    protected O findOptionsInArgsOrNew(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            Object[] array;
            if (this.getOptionClass().isInstance(arg)) {
                return (O)((CloneOptions)arg);
            }
            if (!arg.getClass().isArray() || (array = (Object[])arg).length <= 0 || !this.getOptionClass().isInstance(array[0])) continue;
            return (O)((CloneOptions)array[0]);
        }
        try {
            return (O)((CloneOptions)this.getOptionClass().newInstance());
        }
        catch (Exception e) {
            Throwables.propagate(e);
            assert (false) : "unreachable code";
            return null;
        }
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("CloneParams is needs parameters");
    }

    protected String ifNullDefaultTo(String value, String defaultValue) {
        return value != null ? value : Preconditions.checkNotNull(defaultValue, "defaultValue");
    }
}

