/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.vcloud.compute.config.IsDefaultVDC;
import org.jclouds.vcloud.compute.functions.HardwareForVApp;
import org.jclouds.vcloud.compute.functions.HardwareForVAppTemplate;
import org.jclouds.vcloud.compute.functions.ImageForVAppTemplate;
import org.jclouds.vcloud.compute.functions.VAppToNodeMetadata;
import org.jclouds.vcloud.compute.internal.VCloudTemplateBuilderImpl;
import org.jclouds.vcloud.compute.options.VCloudTemplateOptions;
import org.jclouds.vcloud.compute.strategy.VCloudComputeServiceAdapter;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.functions.VAppTemplatesInOrg;

public class VCloudComputeServiceDependenciesModule
extends AbstractModule {
    @VisibleForTesting
    public static final Map<Status, NodeState> VAPPSTATUS_TO_NODESTATE = ImmutableMap.builder().put(Status.OFF, NodeState.SUSPENDED).put(Status.ON, NodeState.RUNNING).put(Status.RESOLVED, NodeState.PENDING).put(Status.ERROR, NodeState.ERROR).put(Status.UNRECOGNIZED, NodeState.UNRECOGNIZED).put(Status.DEPLOYED, NodeState.PENDING).put(Status.INCONSISTENT, NodeState.PENDING).put(Status.UNKNOWN, NodeState.UNRECOGNIZED).put(Status.MIXED, NodeState.PENDING).put(Status.WAITING_FOR_INPUT, NodeState.PENDING).put(Status.SUSPENDED, NodeState.SUSPENDED).put(Status.UNRESOLVED, NodeState.PENDING).build();

    @Singleton
    @Provides
    protected Map<Status, NodeState> provideVAppStatusToNodeState() {
        return VAPPSTATUS_TO_NODESTATE;
    }

    @Override
    protected void configure() {
        this.bind(new TypeLiteral<Supplier<Location>>(){}).to(DefaultVDC.class).in(Scopes.SINGLETON);
        this.bind(new TypeLiteral<ComputeServiceAdapter<VApp, VAppTemplate, VAppTemplate, Location>>(){}).to(VCloudComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<VApp, NodeMetadata>>(){}).to(VAppToNodeMetadata.class);
        this.bind(TemplateOptions.class).to(VCloudTemplateOptions.class);
        this.bind(TemplateBuilder.class).to(VCloudTemplateBuilderImpl.class);
        this.bind(new TypeLiteral<Function<VApp, Hardware>>(){}).to((TypeLiteral<Function<VApp, Hardware>>)new TypeLiteral<HardwareForVApp>(){});
        this.bind(new TypeLiteral<Function<Org, Iterable<VAppTemplate>>>(){}).to(VAppTemplatesInOrg.class);
        this.bind(new TypeLiteral<Function<VAppTemplate, Image>>(){}).to(ImageForVAppTemplate.class);
        this.bind(new TypeLiteral<Function<VAppTemplate, Hardware>>(){}).to(HardwareForVAppTemplate.class);
        this.bind(new TypeLiteral<Function<Location, Location>>(){}).to(IdentityFunction.class);
    }

    @Provides
    @Singleton
    public NetworkConfig networkConfig(@Network ReferenceType network, FenceMode defaultFenceMode) {
        return new NetworkConfig(network.getName(), network.getHref(), defaultFenceMode);
    }

    @Singleton
    public static class DefaultVDC
    implements Supplier<Location> {
        private final Supplier<Set<? extends Location>> locationsSupplier;
        private final IsDefaultVDC isDefaultVDC;

        @Inject
        DefaultVDC(@Memoized Supplier<Set<? extends Location>> locationsSupplier, IsDefaultVDC isDefaultVDC) {
            this.locationsSupplier = Preconditions.checkNotNull(locationsSupplier, "locationsSupplierSupplier");
            this.isDefaultVDC = Preconditions.checkNotNull(isDefaultVDC, "isDefaultVDC");
        }

        @Override
        public Location get() {
            return Iterables.find((Iterable)this.locationsSupplier.get(), this.isDefaultVDC);
        }
    }
}

