/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.compute.functions.VCloudHardwareBuilderFromResourceAllocations;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.ovf.VCloudVirtualHardwareSection;

public class HardwareForVApp
implements Function<VApp, Hardware> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Function<ReferenceType, Location> findLocationForResource;
    private final VCloudHardwareBuilderFromResourceAllocations rasdToHardwareBuilder;

    @Inject
    protected HardwareForVApp(Function<ReferenceType, Location> findLocationForResource, VCloudHardwareBuilderFromResourceAllocations rasdToHardwareBuilder) {
        this.findLocationForResource = Preconditions.checkNotNull(findLocationForResource, "findLocationForResource");
        this.rasdToHardwareBuilder = Preconditions.checkNotNull(rasdToHardwareBuilder, "rasdToHardwareBuilder");
    }

    @Override
    public Hardware apply(VApp from) {
        Vm vm;
        Preconditions.checkNotNull(from, "VApp");
        Vm vm2 = vm = from.getChildren().size() == 0 ? null : Iterables.get(from.getChildren(), 0);
        if (vm == null) {
            return null;
        }
        VCloudVirtualHardwareSection hardware = vm.getVirtualHardwareSection();
        HardwareBuilder builder = this.rasdToHardwareBuilder.apply((Iterable<? extends ResourceAllocationSettingData>)hardware.getItems());
        builder.location(this.findLocationForResource.apply(Preconditions.checkNotNull(from, "from").getVDC()));
        builder.ids(from.getHref().toASCIIString()).name(from.getName()).supportsImage(ImagePredicates.idEquals(from.getHref().toASCIIString()));
        return builder.build();
    }
}

