/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Envelope;
import org.jclouds.ovf.VirtualHardwareSection;
import org.jclouds.ovf.VirtualSystem;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.functions.VCloudHardwareBuilderFromResourceAllocations;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class HardwareForVAppTemplate
implements Function<VAppTemplate, Hardware> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Function<VAppTemplate, Envelope> templateToEnvelope;
    private final FindLocationForResource findLocationForResource;
    private final VCloudHardwareBuilderFromResourceAllocations rasdToHardwareBuilder;

    @Inject
    protected HardwareForVAppTemplate(Function<VAppTemplate, Envelope> templateToEnvelope, FindLocationForResource findLocationForResource, VCloudHardwareBuilderFromResourceAllocations rasdToHardwareBuilder) {
        this.templateToEnvelope = Preconditions.checkNotNull(templateToEnvelope, "templateToEnvelope");
        this.findLocationForResource = Preconditions.checkNotNull(findLocationForResource, "findLocationForResource");
        this.rasdToHardwareBuilder = Preconditions.checkNotNull(rasdToHardwareBuilder, "rasdToHardwareBuilder");
    }

    @Override
    public Hardware apply(VAppTemplate from) {
        Preconditions.checkNotNull(from, "VAppTemplate");
        Envelope ovf = this.templateToEnvelope.apply(from);
        if (((VirtualSystem)ovf.getVirtualSystem()).getVirtualHardwareSections().size() > 1) {
            this.logger.warn("multiple hardware choices found. using first", ovf);
        }
        VirtualHardwareSection hardware = Iterables.get(((VirtualSystem)ovf.getVirtualSystem()).getVirtualHardwareSections(), 0);
        HardwareBuilder builder = this.rasdToHardwareBuilder.apply((Iterable<? extends ResourceAllocationSettingData>)hardware.getItems());
        if (from.getVDC() != null) {
            builder.location(this.findLocationForResource.apply(from.getVDC()));
        }
        builder.ids(from.getHref().toASCIIString()).name(from.getName()).supportsImage(ImagePredicates.idEquals(from.getHref().toASCIIString()));
        return builder.build();
    }

    protected String getName(String name) {
        return name;
    }
}

