/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Envelope;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class ImageForVAppTemplate
implements Function<VAppTemplate, Image> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final Function<VAppTemplate, Envelope> templateToEnvelope;
    private final FindLocationForResource findLocationForResource;

    @Inject
    protected ImageForVAppTemplate(Function<VAppTemplate, Envelope> templateToEnvelope, FindLocationForResource findLocationForResource) {
        this.templateToEnvelope = Preconditions.checkNotNull(templateToEnvelope, "templateToEnvelope");
        this.findLocationForResource = Preconditions.checkNotNull(findLocationForResource, "findLocationForResource");
    }

    @Override
    public Image apply(VAppTemplate from) {
        Preconditions.checkNotNull(from, "VAppTemplate");
        Envelope ovf = this.templateToEnvelope.apply(from);
        ImageBuilder builder = new ImageBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.uri(from.getHref());
        builder.name(from.getName());
        if (from.getVDC() != null) {
            builder.location(this.findLocationForResource.apply(from.getVDC()));
        }
        builder.description(from.getDescription() != null ? from.getDescription() : from.getName());
        builder.operatingSystem(CIMOperatingSystem.toComputeOs(ovf));
        return builder.build();
    }
}

