/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.util.InetAddresses2;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.util.VCloudComputeUtils;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VApp;

@Singleton
public class VAppToNodeMetadata
implements Function<VApp, NodeMetadata> {
    @Resource
    protected static Logger logger = Logger.NULL;
    protected final FindLocationForResource findLocationForResourceInVDC;
    protected final Function<VApp, Hardware> hardwareForVApp;
    protected final Map<Status, NodeState> vAppStatusToNodeState;
    protected final Map<String, Credentials> credentialStore;

    @Inject
    protected VAppToNodeMetadata(Map<Status, NodeState> vAppStatusToNodeState, Map<String, Credentials> credentialStore, FindLocationForResource findLocationForResourceInVDC, Function<VApp, Hardware> hardwareForVApp) {
        this.hardwareForVApp = Preconditions.checkNotNull(hardwareForVApp, "hardwareForVApp");
        this.findLocationForResourceInVDC = Preconditions.checkNotNull(findLocationForResourceInVDC, "findLocationForResourceInVDC");
        this.credentialStore = Preconditions.checkNotNull(credentialStore, "credentialStore");
        this.vAppStatusToNodeState = Preconditions.checkNotNull(vAppStatusToNodeState, "vAppStatusToNodeState");
    }

    @Override
    public NodeMetadata apply(VApp from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.uri(from.getHref());
        builder.name(from.getName());
        builder.hostname(from.getName());
        builder.location(this.findLocationForResourceInVDC.apply(from.getVDC()));
        builder.group(ComputeServiceUtils.parseGroupFromName(from.getName()));
        builder.operatingSystem(VCloudComputeUtils.toComputeOs(from, null));
        builder.hardware(this.hardwareForVApp.apply(from));
        builder.state(this.vAppStatusToNodeState.get((Object)from.getStatus()));
        Set<String> addresses = VCloudComputeUtils.getIpsFromVApp(from);
        builder.publicAddresses(Iterables.filter(addresses, Predicates.not(InetAddresses2.IsPrivateIPAddress.INSTANCE)));
        builder.privateAddresses(Iterables.filter(addresses, InetAddresses2.IsPrivateIPAddress.INSTANCE));
        LoginCredentials fromApi = VCloudComputeUtils.getCredentialsFrom(from);
        if (fromApi != null && !this.credentialStore.containsKey("node#" + from.getHref().toASCIIString())) {
            this.credentialStore.put("node#" + from.getHref().toASCIIString(), fromApi);
        }
        return builder.build();
    }
}

