/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Envelope;
import org.jclouds.vcloud.TaskInErrorStateException;
import org.jclouds.vcloud.TaskStillRunningException;
import org.jclouds.vcloud.VCloudClient;
import org.jclouds.vcloud.compute.strategy.InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn;
import org.jclouds.vcloud.compute.suppliers.OrgAndVDCToLocationSupplier;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.suppliers.VAppTemplatesSupplier;

@Singleton
public class VCloudComputeServiceAdapter
implements ComputeServiceAdapter<VApp, VAppTemplate, VAppTemplate, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final VCloudClient client;
    protected final Predicate<URI> successTester;
    protected final InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn booter;
    protected final Supplier<Map<String, Org>> nameToOrg;
    protected final Supplier<Set<VAppTemplate>> templates;
    protected final Function<VAppTemplate, Envelope> templateToEnvelope;
    protected final Supplier<Set<? extends Location>> locations;

    @Inject
    protected VCloudComputeServiceAdapter(VCloudClient client, Predicate<URI> successTester, InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn booter, Supplier<Map<String, Org>> nameToOrg, VAppTemplatesSupplier templates, Function<VAppTemplate, Envelope> templateToEnvelope, OrgAndVDCToLocationSupplier locations) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.successTester = Preconditions.checkNotNull(successTester, "successTester");
        this.booter = Preconditions.checkNotNull(booter, "booter");
        this.nameToOrg = Preconditions.checkNotNull(nameToOrg, "nameToOrg");
        this.templates = Preconditions.checkNotNull(templates, "templates");
        this.templateToEnvelope = Preconditions.checkNotNull(templateToEnvelope, "templateToEnvelope");
        this.locations = Preconditions.checkNotNull(locations, "locations");
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<VApp> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        return this.booter.createNodeWithGroupEncodedIntoName(group, name, template);
    }

    @Override
    public Iterable<VAppTemplate> listHardwareProfiles() {
        return this.supportedTemplates();
    }

    private Iterable<VAppTemplate> supportedTemplates() {
        return Iterables.filter((Iterable)this.templates.get(), new Predicate<VAppTemplate>(){

            @Override
            public boolean apply(VAppTemplate from) {
                try {
                    VCloudComputeServiceAdapter.this.templateToEnvelope.apply(from);
                }
                catch (IllegalArgumentException e) {
                    VCloudComputeServiceAdapter.this.logger.warn("Unsupported: " + e.getMessage(), new Object[0]);
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public Iterable<VAppTemplate> listImages() {
        return this.supportedTemplates();
    }

    @Override
    public Iterable<VApp> listNodes() {
        ImmutableSet.Builder<VApp> nodes = ImmutableSet.builder();
        for (Org org : this.nameToOrg.get().values()) {
            for (ReferenceType vdc : org.getVDCs().values()) {
                for (ReferenceType resource : this.client.getVDCClient().getVDC(vdc.getHref()).getResourceEntities().values()) {
                    if (!resource.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) continue;
                    this.addVAppToSetRetryingIfNotYetPresent(nodes, vdc, resource);
                }
            }
        }
        return nodes.build();
    }

    @VisibleForTesting
    void addVAppToSetRetryingIfNotYetPresent(ImmutableSet.Builder<VApp> nodes, ReferenceType vdc, ReferenceType resource) {
        VApp node = null;
        int i = 0;
        while (node == null && i++ < 3) {
            try {
                node = this.client.getVAppClient().getVApp(resource.getHref());
                nodes.add((Object)node);
            }
            catch (NullPointerException e) {
                this.logger.warn("vApp %s not yet present in vdc %s", resource.getName(), vdc.getName());
            }
        }
    }

    @Override
    public Iterable<Location> listLocations() {
        return this.locations.get();
    }

    @Override
    public VApp getNode(String in) {
        URI id = URI.create(in);
        return this.client.getVAppClient().getVApp(id);
    }

    @Override
    public void destroyNode(String id) {
        URI vappId = URI.create(Preconditions.checkNotNull(id, "node.id"));
        VApp vApp = this.cancelAnyRunningTasks(vappId);
        if (vApp.getStatus() != Status.OFF) {
            this.logger.debug(">> powering off VApp vApp(%s), current status: %s", new Object[]{vApp.getName(), vApp.getStatus()});
            try {
                this.waitForTask(this.client.getVAppClient().powerOffVApp(vApp.getHref()));
                vApp = this.client.getVAppClient().getVApp(vApp.getHref());
                this.logger.debug("<< %s vApp(%s)", new Object[]{vApp.getStatus(), vApp.getName()});
            }
            catch (IllegalStateException e) {
                this.logger.warn(e, "<< %s vApp(%s)", new Object[]{vApp.getStatus(), vApp.getName()});
            }
            this.logger.debug(">> undeploying vApp(%s), current status: %s", new Object[]{vApp.getName(), vApp.getStatus()});
            try {
                this.waitForTask(this.client.getVAppClient().undeployVApp(vApp.getHref()));
                vApp = this.client.getVAppClient().getVApp(vApp.getHref());
                this.logger.debug("<< %s vApp(%s)", new Object[]{vApp.getStatus(), vApp.getName()});
            }
            catch (IllegalStateException e) {
                this.logger.warn(e, "<< %s vApp(%s)", new Object[]{vApp.getStatus(), vApp.getName()});
            }
        }
        this.logger.debug(">> deleting vApp(%s)", vApp.getHref());
        this.waitForTask(this.client.getVAppClient().deleteVApp(vApp.getHref()));
        this.logger.debug("<< deleted vApp(%s)", vApp.getHref());
    }

    VApp waitForPendingTasksToComplete(URI vappId) {
        VApp vApp = this.client.getVAppClient().getVApp(vappId);
        if (vApp.getTasks().size() == 0) {
            return vApp;
        }
        for (Task task : vApp.getTasks()) {
            this.waitForTask(task);
        }
        return this.client.getVAppClient().getVApp(vappId);
    }

    VApp cancelAnyRunningTasks(URI vappId) {
        VApp vApp = this.client.getVAppClient().getVApp(vappId);
        if (vApp.getTasks().size() == 0) {
            return vApp;
        }
        for (Task task : vApp.getTasks()) {
            try {
                this.client.getTaskClient().cancelTask(task.getHref());
                this.waitForTask(task);
            }
            catch (TaskInErrorStateException e) {}
        }
        return this.client.getVAppClient().getVApp(vappId);
    }

    public void waitForTask(Task task) {
        if (!this.successTester.apply(task.getHref())) {
            throw new TaskStillRunningException(task);
        }
    }

    @Override
    public void rebootNode(String in) {
        URI id = URI.create(Preconditions.checkNotNull(in, "node.id"));
        this.waitForTask(this.client.getVAppClient().resetVApp(id));
    }

    @Override
    public void resumeNode(String in) {
        URI id = URI.create(Preconditions.checkNotNull(in, "node.id"));
        this.waitForTask(this.client.getVAppClient().powerOnVApp(id));
    }

    @Override
    public void suspendNode(String in) {
        URI id = URI.create(Preconditions.checkNotNull(in, "node.id"));
        this.waitForTask(this.client.getVAppClient().powerOffVApp(id));
    }
}

