/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cim.xml.ResourceAllocationSettingDataHandler;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.ovf.Envelope;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.AsyncClientFactory;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.VCloudClient;
import org.jclouds.vcloud.VCloudToken;
import org.jclouds.vcloud.VCloudVersionsAsyncClient;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.functions.ValidateVAppTemplateAndReturnEnvelopeOrThrowIllegalArgumentException;
import org.jclouds.vcloud.config.DefaultVCloudReferencesModule;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.VCloudSession;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.endpoints.OrgList;
import org.jclouds.vcloud.endpoints.VCloudLogin;
import org.jclouds.vcloud.endpoints.VDC;
import org.jclouds.vcloud.features.CatalogAsyncClient;
import org.jclouds.vcloud.features.CatalogClient;
import org.jclouds.vcloud.features.NetworkAsyncClient;
import org.jclouds.vcloud.features.NetworkClient;
import org.jclouds.vcloud.features.OrgAsyncClient;
import org.jclouds.vcloud.features.OrgClient;
import org.jclouds.vcloud.features.TaskAsyncClient;
import org.jclouds.vcloud.features.TaskClient;
import org.jclouds.vcloud.features.VAppAsyncClient;
import org.jclouds.vcloud.features.VAppClient;
import org.jclouds.vcloud.features.VAppTemplateAsyncClient;
import org.jclouds.vcloud.features.VAppTemplateClient;
import org.jclouds.vcloud.features.VDCAsyncClient;
import org.jclouds.vcloud.features.VDCClient;
import org.jclouds.vcloud.features.VmAsyncClient;
import org.jclouds.vcloud.features.VmClient;
import org.jclouds.vcloud.functions.AllCatalogItemsInCatalog;
import org.jclouds.vcloud.functions.AllCatalogItemsInOrg;
import org.jclouds.vcloud.functions.AllCatalogsInOrg;
import org.jclouds.vcloud.functions.AllVDCsInOrg;
import org.jclouds.vcloud.functions.DefaultNetworkNameInTemplate;
import org.jclouds.vcloud.functions.OrgsForLocations;
import org.jclouds.vcloud.functions.OrgsForNames;
import org.jclouds.vcloud.functions.VAppTemplatesForCatalogItems;
import org.jclouds.vcloud.handlers.ParseVCloudErrorFromHttpResponse;
import org.jclouds.vcloud.internal.VCloudLoginAsyncClient;
import org.jclouds.vcloud.loaders.OVFLoader;
import org.jclouds.vcloud.loaders.VAppTemplateLoader;
import org.jclouds.vcloud.predicates.TaskSuccess;
import org.jclouds.vcloud.xml.ovf.VCloudResourceAllocationSettingDataHandler;

@RequiresHttp
@ConfiguresRestClient
public class VCloudRestClientModule
extends RestClientModule<VCloudClient, VCloudAsyncClient> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(VAppTemplateClient.class, VAppTemplateAsyncClient.class).put(VAppClient.class, VAppAsyncClient.class).put(VmClient.class, VmAsyncClient.class).put(CatalogClient.class, CatalogAsyncClient.class).put(TaskClient.class, TaskAsyncClient.class).put(VDCClient.class, VDCAsyncClient.class).put(NetworkClient.class, NetworkAsyncClient.class).put(OrgClient.class, OrgAsyncClient.class).build();
    static final Function<ReferenceType, String> name = new Function<ReferenceType, String>(){

        @Override
        public String apply(ReferenceType from) {
            return from.getName();
        }
    };

    public VCloudRestClientModule() {
        super(VCloudClient.class, VCloudAsyncClient.class, DELEGATE_MAP);
    }

    @Provides
    @Singleton
    protected VCloudLoginAsyncClient provideVCloudLogin(AsyncClientFactory factory) {
        return factory.create(VCloudLoginAsyncClient.class);
    }

    @Provides
    @Singleton
    protected Supplier<VCloudSession> provideVCloudTokenCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, final VCloudLoginAsyncClient login) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<VCloudSession>(authException, seconds, new Supplier<VCloudSession>(){

            @Override
            public VCloudSession get() {
                try {
                    return (VCloudSession)login.login().get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    Throwables.propagate(e);
                    assert (false) : e;
                    return null;
                }
            }
        });
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<Function<Iterable<CatalogItem>, Iterable<VAppTemplate>>>(){}).to((TypeLiteral<Function<Iterable<CatalogItem>, Iterable<VAppTemplate>>>)new TypeLiteral<VAppTemplatesForCatalogItems>(){});
        this.bind(ResourceAllocationSettingDataHandler.class).to(VCloudResourceAllocationSettingDataHandler.class);
        this.bind(new TypeLiteral<AtomicReference<AuthorizationException>>(){}).toInstance(new AtomicReference());
        this.installDefaultVCloudEndpointsModule();
        this.bind(new TypeLiteral<Function<ReferenceType, Location>>(){}).to((TypeLiteral<Function<ReferenceType, Location>>)new TypeLiteral<FindLocationForResource>(){});
        this.bind(new TypeLiteral<Function<Org, Iterable<Catalog>>>(){}).to((TypeLiteral<Function<Org, Iterable<Catalog>>>)new TypeLiteral<AllCatalogsInOrg>(){});
        this.bind(new TypeLiteral<Function<Org, Iterable<org.jclouds.vcloud.domain.VDC>>>(){}).to((TypeLiteral<Function<Org, Iterable<org.jclouds.vcloud.domain.VDC>>>)new TypeLiteral<AllVDCsInOrg>(){});
        this.bind(new TypeLiteral<Function<Iterable<String>, Iterable<Org>>>(){}).to((TypeLiteral<Function<Iterable<String>, Iterable<Org>>>)new TypeLiteral<OrgsForNames>(){});
        this.bind(new TypeLiteral<Function<Iterable<Location>, Iterable<Org>>>(){}).to((TypeLiteral<Function<Iterable<Location>, Iterable<Org>>>)new TypeLiteral<OrgsForLocations>(){});
        this.bind(new TypeLiteral<Function<Catalog, Iterable<CatalogItem>>>(){}).to((TypeLiteral<Function<Catalog, Iterable<CatalogItem>>>)new TypeLiteral<AllCatalogItemsInCatalog>(){});
        this.bind(new TypeLiteral<Function<Org, Iterable<CatalogItem>>>(){}).to((TypeLiteral<Function<Org, Iterable<CatalogItem>>>)new TypeLiteral<AllCatalogItemsInOrg>(){});
        this.bindCacheLoaders();
        this.bind(new TypeLiteral<Function<VAppTemplate, String>>(){}).annotatedWith(Network.class).to((TypeLiteral<Function<VAppTemplate, String>>)new TypeLiteral<DefaultNetworkNameInTemplate>(){});
        this.bind(new TypeLiteral<Function<VAppTemplate, Envelope>>(){}).to((TypeLiteral<Function<VAppTemplate, Envelope>>)new TypeLiteral<ValidateVAppTemplateAndReturnEnvelopeOrThrowIllegalArgumentException>(){});
    }

    protected void bindCacheLoaders() {
        this.bind(new TypeLiteral<CacheLoader<URI, VAppTemplate>>(){}).to((TypeLiteral<CacheLoader<URI, VAppTemplate>>)new TypeLiteral<VAppTemplateLoader>(){});
        this.bind(new TypeLiteral<CacheLoader<URI, Envelope>>(){}).to((TypeLiteral<CacheLoader<URI, Envelope>>)new TypeLiteral<OVFLoader>(){});
    }

    @Provides
    @Singleton
    @VDC
    protected Supplier<Map<String, String>> provideVDCtoORG(Supplier<Map<String, Org>> orgNameToOrgSuppier) {
        return Suppliers.compose(new Function<Map<String, Org>, Map<String, String>>(){

            @Override
            public Map<String, String> apply(Map<String, Org> arg0) {
                ImmutableMap.Builder<String, String> returnVal = ImmutableMap.builder();
                for (Map.Entry<String, Org> orgr : arg0.entrySet()) {
                    for (String vdc : orgr.getValue().getVDCs().keySet()) {
                        returnVal.put(vdc, orgr.getKey());
                    }
                }
                return returnVal.build();
            }
        }, orgNameToOrgSuppier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Org>> provideOrgMapCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgMapSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<Map<String, Org>>(authException, seconds, supplier);
    }

    @Provides
    @Singleton
    @OrgList
    URI provideOrgListURI(Supplier<VCloudSession> sessionSupplier) {
        VCloudSession session = sessionSupplier.get();
        return URI.create(Iterables.getLast(session.getOrgs().values()).getHref().toASCIIString().replaceAll("org/.*", "org"));
    }

    protected void installDefaultVCloudEndpointsModule() {
        this.install(new DefaultVCloudReferencesModule());
    }

    @VCloudToken
    @Provides
    String provideVCloudToken(Supplier<VCloudSession> cache) {
        return Preconditions.checkNotNull(cache.get().getVCloudToken(), "No token present in session");
    }

    @Provides
    @org.jclouds.vcloud.endpoints.Org
    @Singleton
    protected Supplier<Map<String, ReferenceType>> provideVDCtoORG(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgNameToOrgSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<Map<String, ReferenceType>>(authException, seconds, supplier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<URI, org.jclouds.vcloud.domain.VDC>> provideURIToVDC(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, URItoVDC supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<Map<URI, org.jclouds.vcloud.domain.VDC>>(authException, seconds, supplier);
    }

    @Provides
    @Singleton
    @VCloudLogin
    protected URI provideAuthenticationURI(VCloudVersionsAsyncClient versionService, @Named(value="jclouds.api-version") String version) throws InterruptedException, ExecutionException, TimeoutException {
        SortedMap versions = (SortedMap)versionService.getSupportedVersions().get(180L, TimeUnit.SECONDS);
        Preconditions.checkState(versions.size() > 0, "No versions present");
        Preconditions.checkState(versions.containsKey(version), "version " + version + " not present in: " + versions);
        return (URI)versions.get(version);
    }

    @Provides
    @Singleton
    protected VCloudVersionsAsyncClient provideVCloudVersions(AsyncClientFactory factory) {
        return factory.create(VCloudVersionsAsyncClient.class);
    }

    @Provides
    @Singleton
    protected Org provideOrg(Supplier<Map<String, Org>> orgSupplier, @org.jclouds.vcloud.endpoints.Org ReferenceType defaultOrg) {
        return orgSupplier.get().get(defaultOrg.getName());
    }

    @Provides
    @Singleton
    protected Predicate<URI> successTester(Injector injector, @Named(value="jclouds.vcloud.timeout.task-complete") long completed) {
        return new RetryablePredicate<URI>(injector.getInstance(TaskSuccess.class), completed);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, Catalog>>> provideOrgCatalogItemMapSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgCatalogSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<Map<String, Map<String, Catalog>>>(authException, seconds, supplier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.VDC>>> provideOrgVDCSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgVDCSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<Map<String, Map<String, org.jclouds.vcloud.domain.VDC>>>(authException, seconds, supplier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, Map<String, CatalogItem>>>> provideOrgCatalogItemSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgCatalogItemSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<Map<String, Map<String, Map<String, CatalogItem>>>>(authException, seconds, supplier);
    }

    @Provides
    @Singleton
    protected FenceMode defaultFenceMode(@Named(value="jclouds.vcloud.defaults.fencemode") String fenceMode) {
        return FenceMode.fromValue(fenceMode);
    }

    @Provides
    @Singleton
    protected LoadingCache<URI, VAppTemplate> vAppTemplates(CacheLoader<URI, VAppTemplate> vAppTemplates) {
        return CacheBuilder.newBuilder().build(vAppTemplates);
    }

    @Provides
    @Singleton
    protected LoadingCache<URI, Envelope> envelopes(CacheLoader<URI, Envelope> envelopes) {
        return CacheBuilder.newBuilder().build(envelopes);
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseVCloudErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseVCloudErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseVCloudErrorFromHttpResponse.class);
    }

    @Singleton
    public static class OrgCatalogItemSupplier
    implements Supplier<Map<String, Map<String, Map<String, CatalogItem>>>> {
        protected final Supplier<Map<String, Map<String, Catalog>>> catalogSupplier;
        protected final Function<Catalog, Iterable<CatalogItem>> allCatalogItemsInCatalog;

        @Inject
        protected OrgCatalogItemSupplier(Supplier<Map<String, Map<String, Catalog>>> catalogSupplier, Function<Catalog, Iterable<CatalogItem>> allCatalogItemsInCatalog) {
            this.catalogSupplier = catalogSupplier;
            this.allCatalogItemsInCatalog = allCatalogItemsInCatalog;
        }

        @Override
        public Map<String, Map<String, Map<String, CatalogItem>>> get() {
            return Maps.transformValues(this.catalogSupplier.get(), new Function<Map<String, Catalog>, Map<String, Map<String, CatalogItem>>>(){

                @Override
                public Map<String, Map<String, CatalogItem>> apply(Map<String, Catalog> from) {
                    return Maps.transformValues(from, new Function<Catalog, Map<String, CatalogItem>>(){

                        @Override
                        public Map<String, CatalogItem> apply(Catalog from) {
                            return Maps.uniqueIndex(Iterables.filter(OrgCatalogItemSupplier.this.allCatalogItemsInCatalog.apply(from), Predicates.notNull()), name);
                        }
                    });
                }
            });
        }
    }

    @Singleton
    public static class OrgVDCSupplier
    implements Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.VDC>>> {
        protected final Supplier<Map<String, Org>> orgSupplier;
        private final Function<Org, Iterable<org.jclouds.vcloud.domain.VDC>> allVDCsInOrg;

        @Inject
        protected OrgVDCSupplier(Supplier<Map<String, Org>> orgSupplier, Function<Org, Iterable<org.jclouds.vcloud.domain.VDC>> allVDCsInOrg) {
            this.orgSupplier = orgSupplier;
            this.allVDCsInOrg = allVDCsInOrg;
        }

        @Override
        public Map<String, Map<String, org.jclouds.vcloud.domain.VDC>> get() {
            return Maps.transformValues(Maps.transformValues(this.orgSupplier.get(), this.allVDCsInOrg), new Function<Iterable<org.jclouds.vcloud.domain.VDC>, Map<String, org.jclouds.vcloud.domain.VDC>>(){

                @Override
                public Map<String, org.jclouds.vcloud.domain.VDC> apply(Iterable<org.jclouds.vcloud.domain.VDC> from) {
                    return Maps.uniqueIndex(from, name);
                }
            });
        }
    }

    @Singleton
    private static class OrgNameToOrgSupplier
    implements Supplier<Map<String, ReferenceType>> {
        private final Supplier<VCloudSession> sessionSupplier;

        @Inject
        OrgNameToOrgSupplier(Supplier<VCloudSession> sessionSupplier) {
            this.sessionSupplier = sessionSupplier;
        }

        @Override
        public Map<String, ReferenceType> get() {
            return this.sessionSupplier.get().getOrgs();
        }
    }

    @Singleton
    public static class URItoVDC
    implements Supplier<Map<URI, org.jclouds.vcloud.domain.VDC>> {
        private final Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.VDC>>> orgVDCMap;

        @Inject
        URItoVDC(Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.VDC>>> orgVDCMap) {
            this.orgVDCMap = orgVDCMap;
        }

        @Override
        public Map<URI, org.jclouds.vcloud.domain.VDC> get() {
            return Maps.uniqueIndex(Iterables.concat(Iterables.transform(this.orgVDCMap.get().values(), new Function<Map<String, org.jclouds.vcloud.domain.VDC>, Iterable<org.jclouds.vcloud.domain.VDC>>(){

                @Override
                public Iterable<org.jclouds.vcloud.domain.VDC> apply(Map<String, org.jclouds.vcloud.domain.VDC> from) {
                    return from.values();
                }
            })), new Function<org.jclouds.vcloud.domain.VDC, URI>(){

                @Override
                public URI apply(org.jclouds.vcloud.domain.VDC from) {
                    return from.getHref();
                }
            });
        }
    }

    @Singleton
    public static class OrgCatalogSupplier
    implements Supplier<Map<String, Map<String, Catalog>>> {
        protected final Supplier<Map<String, Org>> orgSupplier;
        protected final Function<Org, Iterable<Catalog>> allCatalogsInOrg;

        @Inject
        protected OrgCatalogSupplier(Supplier<Map<String, Org>> orgSupplier, Function<Org, Iterable<Catalog>> allCatalogsInOrg) {
            this.orgSupplier = orgSupplier;
            this.allCatalogsInOrg = allCatalogsInOrg;
        }

        @Override
        public Map<String, Map<String, Catalog>> get() {
            return Maps.transformValues(Maps.transformValues(this.orgSupplier.get(), this.allCatalogsInOrg), new Function<Iterable<Catalog>, Map<String, Catalog>>(){

                @Override
                public Map<String, Catalog> apply(Iterable<Catalog> from) {
                    return Maps.uniqueIndex(from, name);
                }
            });
        }
    }

    @Singleton
    public static class OrgMapSupplier
    implements Supplier<Map<String, Org>> {
        protected final Supplier<VCloudSession> sessionSupplier;
        protected final Function<Iterable<String>, Iterable<Org>> organizationsForNames;

        @Inject
        protected OrgMapSupplier(Supplier<VCloudSession> sessionSupplier, Function<Iterable<String>, Iterable<Org>> organizationsForNames) {
            this.sessionSupplier = sessionSupplier;
            this.organizationsForNames = organizationsForNames;
        }

        @Override
        public Map<String, Org> get() {
            return Maps.uniqueIndex(this.organizationsForNames.apply(this.sessionSupplier.get().getOrgs().keySet()), name);
        }
    }
}

