/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.firewall.FirewallRule;

public class FirewallService {
    private final boolean enabled;
    List<FirewallRule> firewallRules = Lists.newArrayList();

    public FirewallService(boolean enabled, Iterable<FirewallRule> firewallRules) {
        this.enabled = enabled;
        Iterables.addAll(this.firewallRules, Preconditions.checkNotNull(firewallRules, "firewallRules"));
    }

    public List<FirewallRule> getFirewallRules() {
        return this.firewallRules;
    }

    @Nullable
    public boolean isEnabled() {
        return this.enabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.firewallRules == null ? 0 : ((Object)this.firewallRules).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirewallService other = (FirewallService)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        return !(this.firewallRules == null ? other.firewallRules != null : !((Object)this.firewallRules).equals(other.firewallRules));
    }

    public String toString() {
        return "[enabled=" + this.enabled + ", firewallRules=" + this.firewallRules + "]";
    }
}

