/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Preconditions;

public class IpRange {
    private final String startAddress;
    private final String endAddress;

    public IpRange(String startAddress, String endAddress) {
        this.startAddress = Preconditions.checkNotNull(startAddress, "startAddress");
        this.endAddress = Preconditions.checkNotNull(endAddress, "endAddress");
    }

    public String getStartAddress() {
        return this.startAddress;
    }

    public String getEndAddress() {
        return this.endAddress;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endAddress == null ? 0 : this.endAddress.hashCode());
        result = 31 * result + (this.startAddress == null ? 0 : this.startAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpRange other = (IpRange)obj;
        if (this.endAddress == null ? other.endAddress != null : !this.endAddress.equals(other.endAddress)) {
            return false;
        }
        return !(this.startAddress == null ? other.startAddress != null : !this.startAddress.equals(other.startAddress));
    }

    public String toString() {
        return "[startAddress=" + this.startAddress + ", endAddress=" + this.endAddress + "]";
    }
}

