/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.nat.NatPolicy;
import org.jclouds.vcloud.domain.network.nat.NatRule;
import org.jclouds.vcloud.domain.network.nat.NatType;

public class NatService {
    private final boolean enabled;
    @Nullable
    private final NatType type;
    @Nullable
    private final NatPolicy policy;
    private final List<NatRule> natRules = Lists.newArrayList();

    public NatService(boolean enabled, @Nullable NatType type, @Nullable NatPolicy policy, Iterable<NatRule> natRules) {
        this.enabled = enabled;
        this.type = type;
        this.policy = policy;
        Iterables.addAll(this.natRules, Preconditions.checkNotNull(natRules, "natRules"));
    }

    public List<NatRule> getNatRules() {
        return this.natRules;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public NatType getType() {
        return this.type;
    }

    @Nullable
    public NatPolicy getPolicy() {
        return this.policy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.natRules == null ? 0 : ((Object)this.natRules).hashCode());
        result = 31 * result + (this.policy == null ? 0 : this.policy.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NatService other = (NatService)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.natRules == null ? other.natRules != null : !((Object)this.natRules).equals(other.natRules)) {
            return false;
        }
        if (this.policy == null ? other.policy != null : !this.policy.equals((Object)other.policy)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public String toString() {
        return "[enabled=" + this.enabled + ", natRules=" + this.natRules + ", policy=" + (Object)((Object)this.policy) + ", type=" + (Object)((Object)this.type) + "]";
    }
}

