/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.network.Features;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.IpScope;
import org.jclouds.vcloud.domain.network.OrgNetwork;

public class OrgNetworkImpl
extends ReferenceTypeImpl
implements OrgNetwork {
    @Nullable
    private final ReferenceType org;
    @Nullable
    private final String description;
    private final List<Task> tasks = Lists.newArrayList();
    private final OrgNetwork.Configuration configuration;
    @Nullable
    private final ReferenceType networkPool;
    private final Set<String> allowedExternalIpAddresses = Sets.newLinkedHashSet();

    public OrgNetworkImpl(String name, String type, URI id, @Nullable ReferenceType org, @Nullable String description, Iterable<Task> tasks, OrgNetwork.Configuration configuration, @Nullable ReferenceType networkPool, Iterable<String> allowedExternalIpAddresses) {
        super(name, type, id);
        this.org = org;
        this.description = description;
        Iterables.addAll(this.tasks, Preconditions.checkNotNull(tasks, "tasks"));
        this.configuration = Preconditions.checkNotNull(configuration, "configuration");
        this.networkPool = networkPool;
        Iterables.addAll(this.allowedExternalIpAddresses, Preconditions.checkNotNull(allowedExternalIpAddresses, "allowedExternalIpAddresses"));
    }

    @Override
    public ReferenceType getOrg() {
        return this.org;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public OrgNetwork.Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ReferenceType getNetworkPool() {
        return this.networkPool;
    }

    @Override
    public Set<String> getAllowedExternalIpAddresses() {
        return this.allowedExternalIpAddresses;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowedExternalIpAddresses == null ? 0 : ((Object)this.allowedExternalIpAddresses).hashCode());
        result = 31 * result + (this.configuration == null ? 0 : this.configuration.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.networkPool == null ? 0 : this.networkPool.hashCode());
        result = 31 * result + (this.org == null ? 0 : this.org.hashCode());
        result = 31 * result + (this.tasks == null ? 0 : ((Object)this.tasks).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrgNetworkImpl other = (OrgNetworkImpl)obj;
        if (this.allowedExternalIpAddresses == null ? other.allowedExternalIpAddresses != null : !((Object)this.allowedExternalIpAddresses).equals(other.allowedExternalIpAddresses)) {
            return false;
        }
        if (this.configuration == null ? other.configuration != null : !this.configuration.equals(other.configuration)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.networkPool == null ? other.networkPool != null : !this.networkPool.equals(other.networkPool)) {
            return false;
        }
        if (this.org == null ? other.org != null : !this.org.equals(other.org)) {
            return false;
        }
        return !(this.tasks == null ? other.tasks != null : !((Object)this.tasks).equals(other.tasks));
    }

    @Override
    public String toString() {
        return "[allowedExternalIpAddresses=" + this.allowedExternalIpAddresses + ", configuration=" + this.configuration + ", description=" + this.description + ", networkPool=" + this.networkPool + ", org=" + this.org + ", tasks=" + this.tasks + "]";
    }

    public static class ConfigurationImpl
    implements OrgNetwork.Configuration {
        @Nullable
        private final IpScope ipScope;
        @Nullable
        private final ReferenceType parentNetwork;
        private final FenceMode fenceMode;
        private final Features features;

        public ConfigurationImpl(@Nullable IpScope ipScope, @Nullable ReferenceType parentNetwork, FenceMode fenceMode, @Nullable Features features) {
            this.ipScope = ipScope;
            this.parentNetwork = parentNetwork;
            this.fenceMode = Preconditions.checkNotNull(fenceMode, "fenceMode");
            this.features = features;
        }

        @Override
        public IpScope getIpScope() {
            return this.ipScope;
        }

        @Override
        public ReferenceType getParentNetwork() {
            return this.parentNetwork;
        }

        @Override
        public FenceMode getFenceMode() {
            return this.fenceMode;
        }

        @Override
        @Nullable
        public Features getFeatures() {
            return this.features;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
            result = 31 * result + (this.fenceMode == null ? 0 : this.fenceMode.hashCode());
            result = 31 * result + (this.ipScope == null ? 0 : this.ipScope.hashCode());
            result = 31 * result + (this.parentNetwork == null ? 0 : this.parentNetwork.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigurationImpl other = (ConfigurationImpl)obj;
            if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
                return false;
            }
            if (this.fenceMode == null ? other.fenceMode != null : !this.fenceMode.equals((Object)other.fenceMode)) {
                return false;
            }
            if (this.ipScope == null ? other.ipScope != null : !this.ipScope.equals(other.ipScope)) {
                return false;
            }
            return !(this.parentNetwork == null ? other.parentNetwork != null : !this.parentNetwork.equals(other.parentNetwork));
        }

        public String toString() {
            return "[features=" + this.features + ", fenceMode=" + (Object)((Object)this.fenceMode) + ", ipScope=" + this.ipScope + ", parentNetwork=" + this.parentNetwork + "]";
        }
    }
}

