/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.nat;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum NatType {
    IP_TRANSLATION,
    PORT_FORWARDING,
    UNRECOGNIZED;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static NatType fromValue(String natType) {
        try {
            return NatType.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(natType, "natType")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

