/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.nat.rules;

import com.google.common.base.Preconditions;
import org.jclouds.vcloud.domain.network.nat.NatProtocol;
import org.jclouds.vcloud.domain.network.nat.NatRule;

public class PortForwardingRule
implements NatRule {
    private final String externalIP;
    private final int externalPort;
    private final String internalIP;
    private final int internalPort;
    private final NatProtocol protocol;

    public PortForwardingRule(String externalIP, int externalPort, String internalIP, int internalPort, NatProtocol protocol) {
        this.externalIP = Preconditions.checkNotNull(externalIP, "externalIP");
        this.externalPort = externalPort;
        this.internalIP = Preconditions.checkNotNull(internalIP, "internalIP");
        this.internalPort = internalPort;
        this.protocol = Preconditions.checkNotNull(protocol, "protocol");
    }

    @Override
    public String getExternalIP() {
        return this.externalIP;
    }

    public int getExternalPort() {
        return this.externalPort;
    }

    public String getInternalIP() {
        return this.internalIP;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public NatProtocol getProtocol() {
        return this.protocol;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.externalIP == null ? 0 : this.externalIP.hashCode());
        result = 31 * result + this.externalPort;
        result = 31 * result + (this.internalIP == null ? 0 : this.internalIP.hashCode());
        result = 31 * result + this.internalPort;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortForwardingRule other = (PortForwardingRule)obj;
        if (this.externalIP == null ? other.externalIP != null : !this.externalIP.equals(other.externalIP)) {
            return false;
        }
        if (this.externalPort != other.externalPort) {
            return false;
        }
        if (this.internalIP == null ? other.internalIP != null : !this.internalIP.equals(other.internalIP)) {
            return false;
        }
        if (this.internalPort != other.internalPort) {
            return false;
        }
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals((Object)other.protocol));
    }

    public String toString() {
        return "[externalIP=" + this.externalIP + ", externalPort=" + this.externalPort + ", internalIP=" + this.internalIP + ", internalPort=" + this.internalPort + ", protocol=" + (Object)((Object)this.protocol) + "]";
    }
}

