/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.nat.rules;

import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.nat.NatProtocol;
import org.jclouds.vcloud.domain.network.nat.NatRule;

public class VmRule
implements NatRule {
    @Nullable
    private final String externalIP;
    private final int externalPort;
    @Nullable
    private final String vAppScopedLocalId;
    private final int vmNicId;
    private final int internalPort;
    private final NatProtocol protocol;

    public VmRule(@Nullable String externalIP, int externalPort, @Nullable String vAppScopedLocalId, int vmNicId, int internalPort, NatProtocol protocol) {
        this.externalIP = externalIP;
        this.externalPort = externalPort;
        this.vAppScopedLocalId = vAppScopedLocalId;
        this.vmNicId = vmNicId;
        this.internalPort = internalPort;
        this.protocol = Preconditions.checkNotNull(protocol, "protocol");
    }

    @Override
    @Nullable
    public String getExternalIP() {
        return this.externalIP;
    }

    public Integer getExternalPort() {
        return this.externalPort;
    }

    @Nullable
    public String getVAppScopedLocalId() {
        return this.vAppScopedLocalId;
    }

    public int getVmNicId() {
        return this.vmNicId;
    }

    public Integer getInternalPort() {
        return this.internalPort;
    }

    public NatProtocol getProtocol() {
        return this.protocol;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.externalIP == null ? 0 : this.externalIP.hashCode());
        result = 31 * result + this.externalPort;
        result = 31 * result + this.internalPort;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.vAppScopedLocalId == null ? 0 : this.vAppScopedLocalId.hashCode());
        result = 31 * result + this.vmNicId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmRule other = (VmRule)obj;
        if (this.externalIP == null ? other.externalIP != null : !this.externalIP.equals(other.externalIP)) {
            return false;
        }
        if (this.externalPort != other.externalPort) {
            return false;
        }
        if (this.internalPort != other.internalPort) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals((Object)other.protocol)) {
            return false;
        }
        if (this.vAppScopedLocalId == null ? other.vAppScopedLocalId != null : !this.vAppScopedLocalId.equals(other.vAppScopedLocalId)) {
            return false;
        }
        return this.vmNicId == other.vmNicId;
    }

    public String toString() {
        return "[externalIP=" + this.externalIP + ", externalPort=" + this.externalPort + ", internalPort=" + this.internalPort + ", protocol=" + (Object)((Object)this.protocol) + ", vAppScopedLocalId=" + this.vAppScopedLocalId + ", vmNicId=" + this.vmNicId + "]";
    }
}

