/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.Org;

@Singleton
public class AllCatalogItemsInOrg
implements Function<Org, Iterable<CatalogItem>> {
    private final Function<Org, Iterable<Catalog>> allCatalogsInOrg;
    private final Function<Catalog, Iterable<CatalogItem>> allCatalogItemsInCatalog;

    @Inject
    AllCatalogItemsInOrg(Function<Org, Iterable<Catalog>> allCatalogsInOrg, Function<Catalog, Iterable<CatalogItem>> allCatalogItemsInCatalog) {
        this.allCatalogsInOrg = allCatalogsInOrg;
        this.allCatalogItemsInCatalog = allCatalogItemsInCatalog;
    }

    @Override
    public Iterable<CatalogItem> apply(Org from) {
        return Iterables.concat(Iterables.transform(this.allCatalogsInOrg.apply(from), new Function<Catalog, Iterable<CatalogItem>>(){

            @Override
            public Iterable<CatalogItem> apply(Catalog from) {
                return (Iterable)AllCatalogItemsInOrg.this.allCatalogItemsInCatalog.apply(from);
            }
        }));
    }
}

