/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class AllCatalogsInOrg
implements Function<Org, Iterable<Catalog>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    AllCatalogsInOrg(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    @Override
    public Iterable<Catalog> apply(Org org) {
        Iterable<Catalog> catalogs = FutureIterables.transformParallel(org.getCatalogs().values(), new Function<ReferenceType, Future<Catalog>>(){

            @Override
            public Future<Catalog> apply(ReferenceType from) {
                return AllCatalogsInOrg.this.aclient.getCatalogClient().getCatalog(from.getHref());
            }
        }, this.executor, null, this.logger, "catalogs in " + org.getName());
        return catalogs;
    }
}

