/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.Catalog;
import org.jclouds.vcloud.endpoints.Org;

@Singleton
public class OrgNameCatalogNameVAppTemplateNameToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Map<String, Map<String, CatalogItem>>>> orgCatalogItemMap;
    private final ReferenceType defaultOrg;
    private final ReferenceType defaultCatalog;

    @Inject
    public OrgNameCatalogNameVAppTemplateNameToEndpoint(Supplier<Map<String, Map<String, Map<String, CatalogItem>>>> orgCatalogItemMap, @Org ReferenceType defaultOrg, @Catalog ReferenceType defaultCatalog) {
        this.orgCatalogItemMap = orgCatalogItemMap;
        this.defaultOrg = defaultOrg;
        this.defaultCatalog = defaultCatalog;
    }

    @Override
    public URI apply(Object from) {
        Map<String, Map<String, Map<String, CatalogItem>>> orgCatalogItemMap;
        Iterable orgCatalog = (Iterable)Preconditions.checkNotNull(from, "args");
        Object org = Iterables.get(orgCatalog, 0);
        Object catalog = Iterables.get(orgCatalog, 1);
        Object catalogItem = Iterables.get(orgCatalog, 2);
        if (org == null) {
            org = this.defaultOrg.getName();
        }
        if (catalog == null) {
            catalog = this.defaultCatalog.getName();
        }
        if (!(orgCatalogItemMap = this.orgCatalogItemMap.get()).containsKey(org)) {
            throw new NoSuchElementException("org: " + org + " not found in " + orgCatalogItemMap.keySet());
        }
        Map<String, Map<String, CatalogItem>> catalogs = orgCatalogItemMap.get(org);
        if (!catalogs.containsKey(catalog)) {
            throw new NoSuchElementException("catalog: " + org + "/" + catalog + " not found in " + catalogs.keySet());
        }
        Map<String, CatalogItem> catalogMap = catalogs.get(catalog);
        if (!catalogMap.containsKey(catalogItem)) {
            throw new NoSuchElementException("item: " + org + "/" + catalog + "/" + catalogItem + " not found in " + catalogMap.keySet());
        }
        CatalogItem item = catalogMap.get(catalogItem);
        return Preconditions.checkNotNull(item.getEntity(), "item: " + org + "/" + catalog + "/" + catalogItem + " has no entity").getHref();
    }
}

