/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.TasksList;

@Singleton
public class OrgNameToTasksListEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Org>> orgMap;
    private final ReferenceType defaultTasksList;

    @Inject
    public OrgNameToTasksListEndpoint(Supplier<Map<String, Org>> orgMap, @TasksList ReferenceType defaultTasksList) {
        this.orgMap = orgMap;
        this.defaultTasksList = defaultTasksList;
    }

    @Override
    public URI apply(Object from) {
        Object org = from;
        if (org == null) {
            return this.defaultTasksList.getHref();
        }
        try {
            return Preconditions.checkNotNull(this.orgMap.get().get(org)).getTasksList().getHref();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + " not found in " + this.orgMap.get());
        }
    }
}

