/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.ExceptionParsingListenableFuture;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.concurrent.Futures;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Throwables2;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class VAppTemplatesForCatalogItems
implements Function<Iterable<CatalogItem>, Iterable<VAppTemplate>> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ExecutorService executor;
    private final ReturnNullOnAuthorizationException returnNullOnAuthorizationException;

    @Inject
    VAppTemplatesForCatalogItems(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor, ReturnNullOnAuthorizationException returnNullOnAuthorizationException) {
        this.aclient = aclient;
        this.executor = executor;
        this.returnNullOnAuthorizationException = returnNullOnAuthorizationException;
    }

    @Override
    public Iterable<VAppTemplate> apply(Iterable<CatalogItem> from) {
        return FutureIterables.transformParallel(Iterables.filter(from, new Predicate<CatalogItem>(){

            @Override
            public boolean apply(CatalogItem input) {
                return input.getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml");
            }
        }), new Function<CatalogItem, Future<VAppTemplate>>(){

            @Override
            public Future<VAppTemplate> apply(CatalogItem from) {
                return new ExceptionParsingListenableFuture<VAppTemplate>(Futures.makeListenable(((VCloudAsyncClient)VCloudAsyncClient.class.cast(VAppTemplatesForCatalogItems.this.aclient)).getVAppTemplateClient().getVAppTemplate(from.getEntity().getHref()), VAppTemplatesForCatalogItems.this.executor), VAppTemplatesForCatalogItems.this.returnNullOnAuthorizationException);
            }
        }, this.executor, null, this.logger, "vappTemplates in");
    }

    @Singleton
    static class ReturnNullOnAuthorizationException
    implements Function<Exception, VAppTemplate> {
        ReturnNullOnAuthorizationException() {
        }

        @Override
        public VAppTemplate apply(Exception from) {
            if (from instanceof AuthorizationException) {
                return null;
            }
            return (VAppTemplate)Throwables2.propagateOrNull(from);
        }
    }
}

