/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.internal.CatalogImpl;
import org.jclouds.vcloud.util.Utils;
import org.jclouds.vcloud.xml.TaskHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CatalogHandler
extends ParseSax.HandlerWithResult<Catalog> {
    protected final TaskHandler taskHandler;
    private StringBuilder currentText = new StringBuilder();
    private ReferenceType catalog;
    private Map<String, ReferenceType> contents = Maps.newLinkedHashMap();
    protected List<Task> tasks = Lists.newArrayList();
    private String description;
    private ReferenceType org;
    private boolean published = true;
    private boolean readOnly = true;

    @Inject
    public CatalogHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
    }

    @Override
    public Catalog getResult() {
        return new CatalogImpl(this.catalog.getName(), this.catalog.getType(), this.catalog.getHref(), this.org, this.description, this.contents, this.tasks, this.published, this.readOnly);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.equals("Catalog")) {
            this.catalog = Utils.newReferenceType(attributes, "application/vnd.vmware.vcloud.catalog+xml");
        } else if (qName.equals("CatalogItem")) {
            Utils.putReferenceType(this.contents, attributes);
        } else if (qName.equals("Link") && "up".equals(attributes.get("rel"))) {
            this.org = Utils.newReferenceType(attributes);
        } else if (qName.equals("Link") && "add".equals(attributes.get("rel"))) {
            this.readOnly = false;
        } else {
            this.taskHandler.startElement(uri, localName, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.taskHandler.endElement(uri, name, qName);
        if (qName.equals("Task")) {
            this.tasks.add(this.taskHandler.getResult());
        } else if (qName.equals("Description")) {
            this.description = this.currentOrNull();
        } else if (qName.equals("IsPublished")) {
            this.published = Boolean.parseBoolean(this.currentOrNull());
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

