/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.SortedMap;
import org.jclouds.http.functions.ParseSax;

public class SupportedVersionsHandler
extends ParseSax.HandlerWithResult<SortedMap<String, URI>> {
    private StringBuilder currentText = new StringBuilder();
    private SortedMap<String, URI> contents = Maps.newTreeMap();
    private String version;
    private URI location;

    @Override
    public SortedMap<String, URI> getResult() {
        return this.contents;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Version")) {
            this.version = this.currentOrNull();
        } else if (qName.equals("LoginUrl")) {
            this.location = URI.create(this.currentOrNull());
        } else if (qName.equals("VersionInfo")) {
            this.contents.put(this.version, this.location);
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

