/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.TaskStatus;
import org.jclouds.vcloud.domain.VCloudError;
import org.jclouds.vcloud.domain.internal.TaskImpl;
import org.jclouds.vcloud.util.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TaskHandler
extends ParseSax.HandlerWithResult<Task> {
    protected final DateService dateService;
    private String operation;
    private ReferenceType taskLink;
    private ReferenceType owner;
    private TaskStatus status;
    private Date startTime;
    private Date endTime;
    private Date expiryTime;
    private Task task;
    private VCloudError error;
    private boolean inOwner;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public TaskHandler(DateService dateService) {
        this.dateService = dateService;
    }

    @Override
    public Task getResult() {
        return this.task;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.equalsIgnoreCase("Task")) {
            if (attributes.get("href") != null && !this.inOwner) {
                this.taskLink = Utils.newReferenceType(attributes);
            }
            this.status = TaskStatus.fromValue(attributes.get("status"));
            this.operation = attributes.get("operation");
            if (attributes.containsKey("startTime")) {
                this.startTime = this.parseDate(attributes.get("startTime"));
            }
            if (attributes.containsKey("endTime")) {
                this.endTime = this.parseDate(attributes.get("endTime"));
            }
            if (attributes.containsKey("expiryTime")) {
                this.expiryTime = this.parseDate(attributes.get("expiryTime"));
            }
        } else if (qName.equals("Owner") || qName.equals("Result")) {
            this.owner = Utils.newReferenceType(attributes);
        } else if (qName.equals("Link") && "self".equals(attributes.get("rel"))) {
            this.taskLink = Utils.newReferenceType(attributes);
        } else if (qName.equals("Error")) {
            this.error = Utils.newError(attributes);
        }
    }

    private Date parseDate(String toParse) {
        try {
            return this.dateService.iso8601DateParse(toParse);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ParseException) {
                if (!toParse.endsWith("Z")) {
                    toParse = toParse + "Z";
                }
                return this.dateService.iso8601SecondsDateParse(toParse);
            }
            this.logger.error(e, "error parsing date", new Object[0]);
            return null;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equalsIgnoreCase("Task")) {
            this.task = new TaskImpl(this.taskLink.getHref(), this.operation, this.status, this.startTime, this.endTime, this.expiryTime, this.owner, this.error);
            this.operation = null;
            this.taskLink = null;
            this.status = null;
            this.startTime = null;
            this.endTime = null;
            this.owner = null;
            this.error = null;
        } else if (qName.equalsIgnoreCase("Owner")) {
            this.inOwner = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
    }
}

