/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.GuestCustomizationSection;
import org.jclouds.vcloud.domain.NetworkConnectionSection;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.internal.VmImpl;
import org.jclouds.vcloud.domain.ovf.VCloudOperatingSystemSection;
import org.jclouds.vcloud.domain.ovf.VCloudVirtualHardwareSection;
import org.jclouds.vcloud.util.Utils;
import org.jclouds.vcloud.xml.GuestCustomizationSectionHandler;
import org.jclouds.vcloud.xml.NetworkConnectionSectionHandler;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VCloudVirtualHardwareHandler;
import org.jclouds.vcloud.xml.ovf.VCloudOperatingSystemHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VmHandler
extends ParseSax.HandlerWithResult<Vm> {
    protected final TaskHandler taskHandler;
    protected final VCloudVirtualHardwareHandler virtualHardwareHandler;
    protected final VCloudOperatingSystemHandler operatingSystemHandler;
    protected final GuestCustomizationSectionHandler guestCustomizationHandler;
    protected final NetworkConnectionSectionHandler networkConnectionSectionHandler;
    protected StringBuilder currentText = new StringBuilder();
    protected ReferenceType vm;
    protected Status status;
    protected ReferenceType vdc;
    protected String description;
    protected List<Task> tasks = Lists.newArrayList();
    protected VCloudVirtualHardwareSection hardware;
    protected VCloudOperatingSystemSection os;
    protected NetworkConnectionSection networkConnectionSection;
    protected GuestCustomizationSection guestCustomization;
    protected String vAppScopedLocalId;
    private boolean inTasks;
    private boolean inHardware;
    private boolean inOs;
    private boolean inNetworkConnectionSection;
    private boolean inGuestCustomization;

    @Inject
    public VmHandler(TaskHandler taskHandler, VCloudVirtualHardwareHandler virtualHardwareHandler, VCloudOperatingSystemHandler operatingSystemHandler, NetworkConnectionSectionHandler networkConnectionSectionHandler, GuestCustomizationSectionHandler guestCustomizationHandler) {
        this.taskHandler = taskHandler;
        this.virtualHardwareHandler = virtualHardwareHandler;
        this.operatingSystemHandler = operatingSystemHandler;
        this.networkConnectionSectionHandler = networkConnectionSectionHandler;
        this.guestCustomizationHandler = guestCustomizationHandler;
    }

    @Override
    public Vm getResult() {
        return this.vm == null ? null : new VmImpl(this.vm.getName(), this.vm.getType(), this.vm.getHref(), this.status, this.vdc, this.description, this.tasks, this.hardware, this.os, this.networkConnectionSection, this.guestCustomization, this.vAppScopedLocalId);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.endsWith("VirtualHardwareSection")) {
            this.inHardware = true;
        } else if (qName.endsWith("OperatingSystemSection")) {
            this.inOs = true;
        } else if (qName.endsWith("GuestCustomizationSection")) {
            this.inGuestCustomization = true;
        } else if (qName.endsWith("NetworkConnectionSection")) {
            this.inNetworkConnectionSection = true;
        } else if (qName.endsWith("Tasks")) {
            this.inTasks = true;
        }
        if (this.inHardware) {
            this.virtualHardwareHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inOs) {
            this.operatingSystemHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inNetworkConnectionSection) {
            this.networkConnectionSectionHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inGuestCustomization) {
            this.guestCustomizationHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inTasks) {
            this.taskHandler.startElement(uri, localName, qName, attrs);
        } else if (qName.equals("Vm")) {
            this.vm = Utils.newReferenceType(attributes);
            String status = attributes.get("status");
            if (status != null) {
                this.status = Status.fromValue(Integer.parseInt(status));
            }
        } else if (qName.equals("Link") && "up".equals(attributes.get("rel"))) {
            this.vdc = Utils.newReferenceType(attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.endsWith("VirtualHardwareSection")) {
            this.inHardware = false;
            this.hardware = this.virtualHardwareHandler.getResult();
        } else if (qName.endsWith("OperatingSystemSection")) {
            this.inOs = false;
            this.os = this.operatingSystemHandler.getResult();
        } else if (qName.endsWith("NetworkConnectionSection")) {
            this.inNetworkConnectionSection = false;
            this.networkConnectionSection = this.networkConnectionSectionHandler.getResult();
        } else if (qName.endsWith("GuestCustomizationSection")) {
            this.inGuestCustomization = false;
            this.guestCustomization = this.guestCustomizationHandler.getResult();
        } else if (qName.endsWith("Tasks")) {
            this.inTasks = false;
            this.tasks.add(this.taskHandler.getResult());
        }
        if (this.inHardware) {
            this.virtualHardwareHandler.endElement(uri, name, qName);
        } else if (this.inOs) {
            this.operatingSystemHandler.endElement(uri, name, qName);
        } else if (this.inGuestCustomization) {
            this.guestCustomizationHandler.endElement(uri, name, qName);
        } else if (this.inNetworkConnectionSection) {
            this.networkConnectionSectionHandler.endElement(uri, name, qName);
        } else if (this.inTasks) {
            this.taskHandler.endElement(uri, name, qName);
        } else if (qName.equals("Description")) {
            this.description = this.currentOrNull();
        } else if (qName.equals("VAppScopedLocalId")) {
            this.vAppScopedLocalId = this.currentOrNull();
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inHardware) {
            this.virtualHardwareHandler.characters(ch, start, length);
        } else if (this.inOs) {
            this.operatingSystemHandler.characters(ch, start, length);
        } else if (this.inGuestCustomization) {
            this.guestCustomizationHandler.characters(ch, start, length);
        } else if (this.inNetworkConnectionSection) {
            this.networkConnectionSectionHandler.characters(ch, start, length);
        } else if (this.inTasks) {
            this.taskHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

