/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml.ovf;

import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ovf.NetworkSection;
import org.jclouds.ovf.xml.NetworkSectionHandler;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.ovf.VCloudNetworkSection;
import org.jclouds.vcloud.util.Utils;
import org.xml.sax.Attributes;

public class VCloudNetworkSectionHandler
extends ParseSax.HandlerWithResult<VCloudNetworkSection> {
    private final NetworkSectionHandler networkSectionHandler;
    private ReferenceType net;

    @Inject
    VCloudNetworkSectionHandler(NetworkSectionHandler networkSectionHandler) {
        this.networkSectionHandler = networkSectionHandler;
    }

    @Override
    public VCloudNetworkSection getResult() {
        NetworkSection system = (NetworkSection)this.networkSectionHandler.getResult();
        return new VCloudNetworkSection(this.net.getType(), this.net.getHref(), system.getInfo(), system.getNetworks());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "NetworkSection")) {
            this.net = Utils.newReferenceType(attributes);
        }
        this.networkSectionHandler.startElement(uri, localName, qName, attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.networkSectionHandler.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.networkSectionHandler.characters(ch, start, length);
    }
}

