/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.xml.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jclouds.xml.XMLParser;

@Singleton
public class JAXBParser
implements XMLParser {
    @Override
    public String toXML(Object src) throws IOException {
        return this.toXML(src, src.getClass());
    }

    @Override
    public <T> String toXML(Object src, Class<T> type) throws IOException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
            Marshaller marshaller = context.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.marshal(src, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException ex) {
            throw new IOException("Could not marshall object", ex);
        }
    }

    @Override
    public <T> T fromXML(String xml, Class<T> type) throws IOException {
        try {
            StringReader reader = new StringReader(xml);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (T)unmarshaller.unmarshal((Reader)reader);
        }
        catch (Exception ex) {
            throw new IOException("Could not unmarshall document", ex);
        }
    }
}

