/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class BaseAction
extends Action {
    private boolean _Disposed;
    private final InputType _InputType;
    private Set<Class<?>> _InputTypeClasses;
    private ISelectionProvider _SelectionProvider;
    private SelectionProviderDisposeListener _SelectionProviderDisposeListener;
    private SelectionProviderSelectionChangedListener _SelectionProviderSelectionChangedListener;

    public BaseAction() {
        this(InputType.NONE, null);
    }

    public BaseAction(InputType inputType) {
        this(inputType, null);
    }

    public BaseAction(InputType inputType, ISelectionProvider selectionProvider) {
        this._InputType = inputType;
        this.setSelectionProvider(selectionProvider);
    }

    public BaseAction(ISelectionProvider selectionProvider) {
        this(InputType.NONE, selectionProvider);
    }

    public void addInputTypeClass(Class<?> c) {
        if (this._InputTypeClasses == null) {
            this._InputTypeClasses = new HashSet();
        }
        this._InputTypeClasses.add(c);
    }

    public boolean canRun() {
        InputType inputType = this.getInputType();
        if (inputType.isStructuredSelection()) {
            IStructuredSelection structuredSelection = this.getCurrentStructuredSelection();
            if (this.canRunWithStructuredSelection(structuredSelection)) {
                return true;
            }
        } else if (inputType.isEditorInput()) {
            IEditorInput editorInput;
            IEditorPart editor = this.getActiveEditor();
            IEditorInput iEditorInput = editorInput = editor != null ? editor.getEditorInput() : null;
            if (this.canRunWithEditorInput(editorInput)) {
                return true;
            }
        } else if (this.canRunWithNothing()) {
            return true;
        }
        return false;
    }

    public boolean canRunWithEditorInput(IEditorInput editorInput) {
        if (editorInput == null) {
            return false;
        }
        return this.canRunWithObjectType(editorInput.getClass()) && this.canRunWithObject(editorInput);
    }

    public boolean canRunWithNothing() {
        return this.getInputType() == InputType.NONE;
    }

    public boolean canRunWithObject(Object object) {
        return true;
    }

    public boolean canRunWithObjectType(Class<?> objectType) {
        if (this._InputTypeClasses == null) {
            return false;
        }
        for (Class<?> inputTypeClass : this._InputTypeClasses) {
            if (!inputTypeClass.isAssignableFrom(objectType)) continue;
            return true;
        }
        return false;
    }

    public boolean canRunWithStructuredSelection(IStructuredSelection structuredSelection) {
        if (!this.getInputType().isAcceptableSelectionSize(structuredSelection)) {
            return false;
        }
        if (structuredSelection.isEmpty()) {
            return true;
        }
        for (Object selectedObject : structuredSelection) {
            if (this.canRunWithObjectType(selectedObject.getClass()) && this.canRunWithObject(selectedObject)) continue;
            return false;
        }
        return true;
    }

    public final InputType getInputType() {
        return this._InputType;
    }

    public final ISelectionProvider getSelectionProvider() {
        return this._SelectionProvider;
    }

    public boolean isDisposed() {
        return this._Disposed;
    }

    public void removeInputTypeClass(Class<?> c) {
        if (this._InputTypeClasses == null) {
            return;
        }
        if (this._InputTypeClasses.contains(c)) {
            this._InputTypeClasses.remove(c);
        }
    }

    public void reportError(Exception e) {
        this.openErrorMessageDialog(e.getMessage());
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        InputType inputType = this.getInputType();
        if (inputType.isStructuredSelection()) {
            IStructuredSelection structuredSelection = this.getCurrentStructuredSelection();
            if (this.canRunWithStructuredSelection(structuredSelection)) {
                this.runWithStructuredSelection(structuredSelection);
                return;
            }
        } else if (inputType.isEditorInput()) {
            IEditorInput editorInput;
            IEditorPart editor = this.getActiveEditor();
            IEditorInput iEditorInput = editorInput = editor != null ? editor.getEditorInput() : null;
            if (this.canRunWithEditorInput(editorInput)) {
                this.runWithEditorInput(editorInput);
                return;
            }
        } else if (this.canRunWithNothing()) {
            this.runWithNothing();
            return;
        }
        this.openErrorMessageDialog(String.valueOf(this.getText()) + " action was not handled.");
    }

    public void runWithEditorInput(IEditorInput editorInput) {
        try {
            this.runWithObject(editorInput);
        }
        catch (Exception e) {
            this.reportError(e);
        }
    }

    public void runWithNothing() {
        try {
            this.runWithObject(null);
        }
        catch (Exception e) {
            this.reportError(e);
        }
    }

    public void runWithObject(Object object) throws Exception {
        this.openInformationMessageDialog(String.valueOf(object));
    }

    public void runWithStructuredSelection(IStructuredSelection selection) {
        for (Object selectedObject : selection) {
            try {
                this.runWithObject(selectedObject);
            }
            catch (Exception e) {
                this.reportError(e);
                break;
            }
        }
    }

    public final void setSelectionProvider(ISelectionProvider selectionProvider) {
        if (this._SelectionProvider != null) {
            if (this._SelectionProviderSelectionChangedListener != null) {
                this._SelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._SelectionProviderSelectionChangedListener);
            }
            if (this._SelectionProvider instanceof Viewer) {
                this.unhookViewer((Viewer)this._SelectionProvider);
            }
        }
        this._SelectionProvider = selectionProvider;
        if (this._SelectionProvider != null) {
            if (this._SelectionProviderSelectionChangedListener == null) {
                this._SelectionProviderSelectionChangedListener = new SelectionProviderSelectionChangedListener();
            }
            this._SelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this._SelectionProviderSelectionChangedListener);
            if (this._SelectionProvider instanceof Viewer) {
                this.hookViewer((Viewer)this._SelectionProvider);
            }
        }
        this.updateState();
    }

    public void updateState() {
        this.setEnabled(this.canRun());
    }

    protected final IEditorPart getActiveEditor() {
        IWorkbenchPage workBenchPage = this.getActiveWorkbenchPage();
        if (workBenchPage != null) {
            return workBenchPage.getActiveEditor();
        }
        return null;
    }

    protected final Shell getActiveShell() {
        return this.getCurrentDisplay().getActiveShell();
    }

    protected final IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchWindow workBenchWindow = this.getActiveWorkbenchWindow();
        if (workBenchWindow != null) {
            return workBenchWindow.getActivePage();
        }
        return null;
    }

    protected final IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workBench = this.getWorkbench();
        return workBench.getActiveWorkbenchWindow();
    }

    protected final Display getCurrentDisplay() {
        return Display.getCurrent();
    }

    protected final ISelection getCurrentSelection() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            return selectionProvider.getSelection();
        }
        return null;
    }

    protected final IStructuredSelection getCurrentStructuredSelection() {
        ISelection selection = this.getCurrentSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected String getDefaultErrorMessageDialogTitle() {
        return String.valueOf(this.getText()) + " Failed";
    }

    protected String getDefaultInformationMessageDialogTitle() {
        return this.getText();
    }

    protected String getDefaultWarningMessageDialogTitle() {
        return this.getText();
    }

    protected final ISelectionService getSelectionService() {
        IWorkbenchWindow workBenchWindow = this.getActiveWorkbenchWindow();
        return workBenchWindow.getSelectionService();
    }

    protected final IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected void hookViewer(Viewer viewer) {
        Control control = viewer.getControl();
        if (this._SelectionProviderDisposeListener == null) {
            this._SelectionProviderDisposeListener = new SelectionProviderDisposeListener();
        }
        control.addDisposeListener((DisposeListener)this._SelectionProviderDisposeListener);
    }

    protected final IEditorPart openEditor(IEditorInput input, String editorId) throws PartInitException {
        return this.getActiveWorkbenchPage().openEditor(input, editorId);
    }

    protected final IEditorPart openEditor(IEditorInput input, String editorId, boolean activate) throws PartInitException {
        return this.getActiveWorkbenchPage().openEditor(input, editorId, activate);
    }

    protected final IEditorPart openEditor(IEditorInput input, String editorId, boolean activate, int matchFlags) throws PartInitException {
        return this.getActiveWorkbenchPage().openEditor(input, editorId, activate, matchFlags);
    }

    protected final IEditorPart openEditor(String filePath) throws PartInitException {
        IPath location = Path.fromOSString((String)filePath);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(location);
        FileStoreEditorInput fileStoreEditorInput = new FileStoreEditorInput(fileStore);
        String editorId = "org.eclipse.ui.systemExternalEditor";
        IEditorDescriptor editorDescriptor = this.getWorkbench().getEditorRegistry().getDefaultEditor(filePath);
        if (editorDescriptor != null) {
            editorId = editorDescriptor.getId();
        }
        return this.openEditor((IEditorInput)fileStoreEditorInput, editorId);
    }

    protected final void openErrorMessageDialog(String message) {
        this.openErrorMessageDialog(this.getDefaultErrorMessageDialogTitle(), message);
    }

    protected final void openErrorMessageDialog(String title, String message) {
        MessageDialog.openError((Shell)this.getActiveShell(), (String)title, (String)message);
    }

    protected final void openErrorMessageDialog(Throwable t) {
        this.openErrorMessageDialog("Unhandled exception: " + t);
    }

    protected final void openInformationMessageDialog(String message) {
        this.openInformationMessageDialog(this.getDefaultInformationMessageDialogTitle(), message);
    }

    protected final void openInformationMessageDialog(String title, String message) {
        MessageDialog.openInformation((Shell)this.getActiveShell(), (String)title, (String)message);
    }

    protected final void openWarningMessageDialog(String message) {
        this.openWarningMessageDialog(this.getDefaultWarningMessageDialogTitle(), message);
    }

    protected final void openWarningMessageDialog(String title, String message) {
        MessageDialog.openWarning((Shell)this.getActiveShell(), (String)title, (String)message);
    }

    protected void unhookViewer(Viewer viewer) {
        if (this._SelectionProviderDisposeListener != null) {
            Control control = viewer.getControl();
            control.removeDisposeListener((DisposeListener)this._SelectionProviderDisposeListener);
        }
    }

    public static enum InputType {
        EDITOR_INPUT(false, true, Integer.MAX_VALUE, Integer.MIN_VALUE),
        MULTI_STRUCTURED_SELECTION(true, false, 2, Integer.MAX_VALUE),
        NONE(false, false, Integer.MAX_VALUE, Integer.MIN_VALUE),
        OPTIONAL_STRUCTURED_SELECTION(true, false, 0, Integer.MAX_VALUE),
        SINGLE_STRUCTURED_SELECTION(true, false, 1, 1),
        STRUCTURED_SELECTION(true, false, 1, Integer.MAX_VALUE);

        private final boolean _EditorInput;
        private final int _MaximumSelectionSize;
        private final int _MinimumSelectionSize;
        private final boolean _StructuredSelection;

        private InputType(boolean structuredSelection, boolean editorInput, int minimumSelectionSize, int maximumSelectionSize) {
            this._StructuredSelection = structuredSelection;
            this._EditorInput = editorInput;
            this._MinimumSelectionSize = minimumSelectionSize;
            this._MaximumSelectionSize = maximumSelectionSize;
        }

        public int getMaximumSelectionSize() {
            return this._MaximumSelectionSize;
        }

        public int getMinimumSelectionSize() {
            return this._MinimumSelectionSize;
        }

        public boolean isAcceptableSelectionSize(IStructuredSelection structuredSelection) {
            int size;
            int n = size = structuredSelection == null ? 0 : structuredSelection.size();
            return size >= this.getMinimumSelectionSize() && size <= this.getMaximumSelectionSize();
        }

        public boolean isEditorInput() {
            return this._EditorInput;
        }

        public boolean isStructuredSelection() {
            return this._StructuredSelection;
        }
    }

    private class SelectionProviderDisposeListener
    implements DisposeListener {
        private SelectionProviderDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            BaseAction.this.setSelectionProvider(null);
        }
    }

    private class SelectionProviderSelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionProviderSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            BaseAction.this.updateState();
        }
    }
}

