/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.actions;

import com.fusesource.zk.core.EclipseCoreActivator;
import com.fusesource.zk.core.actions.BaseAction;
import com.fusesource.zk.core.model.DataModel;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.MessageBox;

public abstract class BaseDeleteAction
extends BaseAction {
    private static final ImageDescriptor ACTION_IMAGE_DESCRIPTOR = EclipseCoreActivator.getManagedImageDescriptor("IMAGE_KEY_ACTION_DELETE");
    private static final String ACTION_TEXT = "Delete";
    private static final String ACTION_TOOL_TIP_TEXT = "Delete";

    public BaseDeleteAction() {
        this(BaseAction.InputType.STRUCTURED_SELECTION);
    }

    public BaseDeleteAction(BaseAction.InputType inputType) {
        super(inputType);
        this.setImageDescriptor(ACTION_IMAGE_DESCRIPTOR);
        this.setText("Delete");
        this.setToolTipText("Delete");
    }

    @Override
    public void runWithObject(Object object) throws Exception {
        String typeName = this.getObjectTypeName(object);
        if (typeName == null) {
            return;
        }
        String name = this.getObjectName(object);
        if (name == null) {
            return;
        }
        MessageBox messageBox = new MessageBox(this.getActiveShell(), 196);
        messageBox.setMessage("Are you sure you want to delete the " + typeName + " '" + name + "'?");
        messageBox.setText("Confirm Delete");
        int response = messageBox.open();
        if (response == 64) {
            try {
                this.delete(object);
            }
            catch (Exception e) {
                throw new Exception("Failed to delete the " + typeName + " '" + name + "'.", e);
            }
        }
    }

    protected void delete(Object object) throws Exception {
        if (object instanceof DataModel) {
            ((DataModel)object).deleteData();
        }
    }

    protected abstract String getObjectName(Object var1);

    protected abstract String getObjectTypeName(Object var1);
}

