/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.actions;

import com.fusesource.zk.core.actions.BaseAction;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.FormEditor;

public abstract class BaseOpenAction
extends BaseAction {
    private static final String ACTION_TEXT = "Open";
    private static final String ACTION_TOOL_TIP_TEXT = "Open";
    private IOpenListener _OpenListener;

    public BaseOpenAction() {
        this(BaseAction.InputType.STRUCTURED_SELECTION);
    }

    public BaseOpenAction(BaseAction.InputType inputType) {
        super(inputType);
        this.setText("Open");
        this.setToolTipText("Open");
        this._OpenListener = new IOpenListener(){

            public void open(OpenEvent event) {
                BaseOpenAction.this.run();
            }
        };
    }

    protected abstract String getAssociatedEditorId(Object var1);

    protected abstract IEditorInput getAssociatedEditorInput(String var1, Object var2);

    protected String getAssociatedEditorPageId(String editorId, Object object) {
        return null;
    }

    protected String getOpenErrorMessage(Object object, IEditorInput input, String editorId, Exception e) {
        return "Failed to open '" + object + "'.";
    }

    @Override
    protected void hookViewer(Viewer viewer) {
        super.hookViewer(viewer);
        if (viewer instanceof StructuredViewer) {
            ((StructuredViewer)viewer).addOpenListener(this._OpenListener);
        }
    }

    protected IEditorPart open(Object object, IEditorInput input, String editorId, String pageId) throws Exception {
        IEditorPart editor = this.openEditor(input, editorId, true);
        if (pageId != null && editor instanceof FormEditor) {
            ((FormEditor)editor).setActivePage(pageId);
        }
        return editor;
    }

    @Override
    public void runWithObject(Object object) throws Exception {
        String editorId = this.getAssociatedEditorId(object);
        if (editorId == null) {
            return;
        }
        IEditorInput input = this.getAssociatedEditorInput(editorId, object);
        if (input == null) {
            return;
        }
        String pageId = this.getAssociatedEditorPageId(editorId, object);
        try {
            this.open(object, input, editorId, pageId);
        }
        catch (Exception e) {
            throw new Exception(this.getOpenErrorMessage(object, input, editorId, e), e);
        }
    }

    @Override
    protected void unhookViewer(Viewer viewer) {
        super.unhookViewer(viewer);
        if (viewer instanceof StructuredViewer) {
            ((StructuredViewer)viewer).removeOpenListener(this._OpenListener);
        }
    }
}

