/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.editors;

import com.fusesource.zk.core.editors.BaseEditorInput;
import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.viewers.DataModelElementType;

public abstract class DataModelEditorInput<M extends DataModel<M, ?, ?>>
extends BaseEditorInput {
    private final DataModelElementType _ElementType;
    private final M _Model;

    public DataModelEditorInput(String editorId, M model, DataModelElementType elementType) {
        super(editorId);
        this._Model = model;
        this._ElementType = elementType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataModelEditorInput other = (DataModelEditorInput)obj;
        return !(this._Model == null ? other._Model != null : !((DataModel)this._Model).equals(other._Model));
    }

    public boolean exists() {
        M model = this.getModel();
        return model != null && !((DataModel)model).isDestroyed();
    }

    public final DataModelElementType getElementType() {
        return this._ElementType;
    }

    public M getModel() {
        return this._Model;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._Model == null ? 0 : ((DataModel)this._Model).hashCode());
        return result;
    }

    @Override
    public final String getName() {
        return this.getElementType().getText(this.getModel());
    }

    @Override
    public final String getToolTipText() {
        return this.getElementType().getToolTipText(this.getModel());
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [Model=" + this._Model + "]";
    }
}

