/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.editors;

import com.fusesource.zk.core.actions.BaseAction;
import com.fusesource.zk.core.actions.BaseOpenAction;
import com.fusesource.zk.core.actions.RefreshAction;
import com.fusesource.zk.core.editors.DataModelEditorInput;
import com.fusesource.zk.core.editors.DataModelFormPage;
import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.GenericDataModelEvent;
import com.fusesource.zk.core.model.IGenericDataModelEventListener;
import com.fusesource.zk.core.reflect.SwtThreadSafeDelegatingInvocationHandler;
import com.fusesource.zk.core.viewers.DataModelElementType;
import com.fusesource.zk.core.viewers.IElementType;
import com.fusesource.zk.core.widgets.BaseControlContribution;
import com.fusesource.zk.core.widgets.ElementTypeDataModelImageHyperlinkView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class DataModelFormEditor<M extends DataModel<M, ?, ?>>
extends SharedHeaderFormEditor {
    private M _Model;
    private IGenericDataModelEventListener _ModelEventListener;
    private final List<DataModelFormPage<M>> _Pages = new ArrayList<DataModelFormPage<M>>();
    private RefreshAction _RefreshAction;

    public int addPage(DataModelFormPage<M> page) throws PartInitException {
        return this.addPage((IFormPage)page);
    }

    public int addPage(IFormPage page) throws PartInitException {
        int index = this.getPageCount();
        this.addPage(index, page);
        return index;
    }

    public void addPage(int index, DataModelFormPage<M> page) throws PartInitException {
        this.addPage(index, (IFormPage)page);
    }

    public void addPage(int index, IFormPage page) throws PartInitException {
        if (!(page instanceof DataModelFormPage)) {
            throw new PartInitException("Invalid Page: Must be " + DataModelFormPage.class.getName());
        }
        DataModelFormPage dataModelFormPage = (DataModelFormPage)page;
        super.addPage(index, page);
        this._Pages.add(index, dataModelFormPage);
        Image pageImage = dataModelFormPage.getImage();
        if (pageImage != null) {
            this.setPageImage(index, pageImage);
        }
    }

    public void dispose() {
        super.dispose();
        this.unregisterModelEventListener();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public final DataModelElementType getElementType() {
        return this.getDataModelEditorInput().getElementType();
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public M getModel() {
        return this._Model;
    }

    public String getModelDestroyedMessage() {
        return null;
    }

    public List<DataModelFormPage<M>> getPages() {
        return Collections.unmodifiableList(this._Pages);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!(input instanceof DataModelEditorInput)) {
            throw new PartInitException("Invalid Input: Must be " + DataModelEditorInput.class.getName());
        }
        this._Model = ((DataModelEditorInput)input).getModel();
        this.registerModelEventListener();
        this.updateTitle();
    }

    public final DataModelEditorInput<M> getDataModelEditorInput() {
        return (DataModelEditorInput)this.getEditorInput();
    }

    public boolean isDirty() {
        if (((DataModel)this.getModel()).isDestroyed()) {
            return false;
        }
        for (DataModelFormPage<M> page : this._Pages) {
            if (!page.isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void removePage(int pageIndex) {
        super.removePage(pageIndex);
        DataModelFormPage<M> removePage = null;
        for (DataModelFormPage<M> page : this._Pages) {
            if (page.getIndex() != pageIndex) continue;
            removePage = page;
            break;
        }
        if (removePage != null) {
            this._Pages.remove(removePage);
        }
    }

    public void setFocus() {
        IFormPage formPage;
        super.setFocus();
        RefreshAction refreshAction = this.getRefreshAction();
        if (refreshAction != null) {
            refreshAction.updateState();
        }
        if ((formPage = this.getActivePageInstance()) == null) {
            return;
        }
        if (!(formPage instanceof DataModelFormPage)) {
            return;
        }
        DataModelFormPage dataModelFormPage = (DataModelFormPage)formPage;
        dataModelFormPage.forceLayout();
    }

    protected void addImageHyperlinkToolBarContribution(IManagedForm headerForm, final IToolBarManager toolBarManager, final BaseControlContribution baseControlContribution, final DataModel<?, ?, ?> model) {
        final Separator separator = new Separator();
        toolBarManager.add((IContributionItem)separator);
        toolBarManager.add((IContributionItem)baseControlContribution);
        baseControlContribution.addControlDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!model.isDestroyed()) {
                    return;
                }
                toolBarManager.remove((IContributionItem)separator);
                separator.dispose();
                toolBarManager.remove((IContributionItem)baseControlContribution);
                toolBarManager.update(true);
            }
        });
    }

    protected void addPages() {
    }

    protected void contributeToToolBar(IManagedForm headerForm, IToolBarManager toolBarManager) {
        BaseControlContribution ownerImageHyperlinkToolBarContribution;
        BaseControlContribution parentImageHyperlinkToolBarContribution;
        RefreshAction refreshAction = this.getRefreshAction();
        if (refreshAction != null) {
            toolBarManager.add((IAction)refreshAction);
        }
        DataModel<?, ?, ?> parentModel = this.getParentModel();
        DataModelElementType parentModelElementType = this.getParentModelElementType();
        if (parentModel != null && parentModelElementType != null && (parentImageHyperlinkToolBarContribution = this.createImageHyperlinkToolBarContribution("Parent Link", parentModel, parentModelElementType)) != null) {
            this.addImageHyperlinkToolBarContribution(headerForm, toolBarManager, parentImageHyperlinkToolBarContribution, parentModel);
        }
        DataModel<?, ?, ?> ownerModel = this.getOwnerModel();
        DataModelElementType ownerModelElementType = this.getOwnerModelElementType();
        if (ownerModel != null && ownerModelElementType != null && ownerModel != parentModel && (ownerImageHyperlinkToolBarContribution = this.createImageHyperlinkToolBarContribution("Owner Link", ownerModel, ownerModelElementType)) != null) {
            this.addImageHyperlinkToolBarContribution(headerForm, toolBarManager, ownerImageHyperlinkToolBarContribution, ownerModel);
        }
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        super.createHeaderContents(headerForm);
        FormToolkit toolkit = headerForm.getToolkit();
        ScrolledForm scrolledForm = headerForm.getForm();
        Form form = scrolledForm.getForm();
        toolkit.decorateFormHeading(form);
        this.updateTitle();
        this.makeActions();
        IToolBarManager toolBarManager = form.getToolBarManager();
        this.contributeToToolBar(headerForm, toolBarManager);
        toolBarManager.update(true);
    }

    protected BaseControlContribution createImageHyperlinkToolBarContribution(String id, final DataModel<?, ?, ?> model, final DataModelElementType modelElementType) {
        BaseControlContribution controlContribution = new BaseControlContribution(id){

            @Override
            protected Control createControlInternal(Composite parent) {
                ImageHyperlink imageHyperlink = new ImageHyperlink(parent, 192);
                HyperlinkGroup group = new HyperlinkGroup(imageHyperlink.getDisplay());
                group.setHyperlinkUnderlineMode(2);
                group.add((Hyperlink)imageHyperlink);
                imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        BaseOpenAction openAction = modelElementType.getOpenAction();
                        if (openAction != null) {
                            try {
                                openAction.runWithObject(model);
                            }
                            catch (Exception e1) {
                                openAction.reportError(e1);
                            }
                        }
                    }
                });
                ElementTypeDataModelImageHyperlinkView view = new ElementTypeDataModelImageHyperlinkView(model, imageHyperlink, (IElementType)modelElementType);
                view.updateView();
                return imageHyperlink;
            }
        };
        return controlContribution;
    }

    protected Image getFormImage(M model) {
        return this.getElementType().getLargeImage(model);
    }

    protected String getFormText(M model) {
        return this.getElementType().getText(model);
    }

    protected DataModel<?, ?, ?> getOwnerModel() {
        M model = this.getModel();
        return ((DataModel)model).getOwnerModel();
    }

    protected DataModelElementType getOwnerModelElementType() {
        return null;
    }

    protected List<DataModelFormPage<M>> getPagesInternal() {
        return this._Pages;
    }

    protected DataModel<?, ?, ?> getParentModel() {
        M model = this.getModel();
        return ((DataModel)model).getParentModel();
    }

    protected DataModelElementType getParentModelElementType() {
        return null;
    }

    protected String getPartName(M model) {
        return this.getElementType().getText(model);
    }

    protected final RefreshAction getRefreshAction() {
        return this._RefreshAction;
    }

    protected Image getTitleImage(M model) {
        return this.getElementType().getImage(model);
    }

    protected String getTitleToolTip(M model) {
        return this.getElementType().getToolTipText(model);
    }

    protected void makeActions() {
        this._RefreshAction = new RefreshAction(BaseAction.InputType.EDITOR_INPUT);
    }

    protected void modelDataChanged(GenericDataModelEvent event) {
        if (this.getContainer().isDisposed()) {
            return;
        }
        this.updateTitle();
        for (DataModelFormPage<M> page : this._Pages) {
            page.modelDataChanged(event);
        }
    }

    protected void modelDataRefreshed(GenericDataModelEvent event) {
        if (this.getContainer().isDisposed()) {
            return;
        }
        this.updateTitle();
        for (DataModelFormPage<M> page : this._Pages) {
            page.modelDataRefreshed(event);
        }
    }

    protected void modelDestroyed(GenericDataModelEvent event) {
        if (this.getContainer().isDisposed()) {
            return;
        }
        this.updateTitle();
        this.editorDirtyStateChanged();
        String modelDestroyedMessage = this.getModelDestroyedMessage();
        if (modelDestroyedMessage != null) {
            IManagedForm headerForm = this.getHeaderForm();
            ScrolledForm scrolledForm = headerForm.getForm();
            Form form = scrolledForm.getForm();
            form.setMessage(modelDestroyedMessage, 3);
        }
        for (DataModelFormPage<M> page : this._Pages) {
            page.modelDestroyed(event);
        }
    }

    protected void registerModelEventListener() {
        M model = this.getModel();
        if (model == null) {
            return;
        }
        if (this._ModelEventListener == null) {
            ModelEventListener modelEventListenerDelegate = new ModelEventListener();
            this._ModelEventListener = (IGenericDataModelEventListener)SwtThreadSafeDelegatingInvocationHandler.createProxyInstance(modelEventListenerDelegate, IGenericDataModelEventListener.class, true);
        }
        ((DataModel)model).addGenericEventListener(this._ModelEventListener);
    }

    protected void saveCompleted() {
        for (DataModelFormPage<M> page : this._Pages) {
            page.saveCompleted();
        }
        this.editorDirtyStateChanged();
    }

    protected void unregisterModelEventListener() {
        M model = this.getModel();
        if (model != null && this._ModelEventListener != null) {
            ((DataModel)model).removeGenericEventListener(this._ModelEventListener);
        }
    }

    protected void updateTitle() {
        M model = this.getModel();
        if (model == null) {
            return;
        }
        this.setPartName(this.getPartName(model));
        this.setTitleToolTip(this.getTitleToolTip(model));
        this.setTitleImage(this.getTitleImage(model));
        IManagedForm headerForm = this.getHeaderForm();
        if (headerForm != null) {
            ScrolledForm scrolledForm = headerForm.getForm();
            Form form = scrolledForm.getForm();
            form.setText(this.getFormText(model));
            form.setImage(this.getFormImage(model));
        }
    }

    public final class ModelEventListener
    implements IGenericDataModelEventListener,
    SwtThreadSafeDelegatingInvocationHandler.IWidgetProvider {
        @Override
        public void dataModelDataChanged(GenericDataModelEvent event) {
            DataModelFormEditor.this.modelDataChanged(event);
        }

        @Override
        public void dataModelDataRefreshed(GenericDataModelEvent event) {
            DataModelFormEditor.this.modelDataRefreshed(event);
        }

        @Override
        public void dataModelDestroyed(GenericDataModelEvent event) {
            DataModelFormEditor.this.modelDestroyed(event);
        }

        @Override
        public Widget getWidget() {
            return DataModelFormEditor.this.getContainer();
        }
    }
}

