/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.editors;

import com.fusesource.zk.core.editors.DataModelFormEditor;
import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.GenericDataModelEvent;
import com.fusesource.zk.core.widgets.InfoBar;
import com.fusesource.zk.core.widgets.TableEdit;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class DataModelFormPage<M extends DataModel<M, ?, ?>>
extends FormPage {
    public static final FormData FILL_BOTH_FORM_DATA = new FormData();
    public static final FormData FILL_WIDTH_FORM_DATA = new FormData();
    private Composite _Client;
    private boolean _Dirty;
    private Image _Image;
    private InfoBar _InfoBar;
    private String _InfoText;
    private boolean _ProgrammaticUpdate;

    static {
        DataModelFormPage.FILL_BOTH_FORM_DATA.top = new FormAttachment(0, 0);
        DataModelFormPage.FILL_BOTH_FORM_DATA.left = new FormAttachment(0, 0);
        DataModelFormPage.FILL_BOTH_FORM_DATA.bottom = new FormAttachment(100, 0);
        DataModelFormPage.FILL_BOTH_FORM_DATA.right = new FormAttachment(100, 0);
        DataModelFormPage.FILL_WIDTH_FORM_DATA.left = new FormAttachment(0, 0);
        DataModelFormPage.FILL_WIDTH_FORM_DATA.right = new FormAttachment(100, 0);
    }

    public DataModelFormPage(DataModelFormEditor<M> editor, String id, String title) {
        super(editor, id, title);
    }

    public DataModelFormEditor<M> getDataModelFormEditor() {
        return (DataModelFormEditor)this.getEditor();
    }

    public Image getImage() {
        return this._Image;
    }

    public String getInfoText() {
        return this._InfoText;
    }

    public M getModel() {
        return this.getDataModelFormEditor().getModel();
    }

    public boolean isDirty() {
        return this._Dirty;
    }

    public boolean isProgrammaticUpdate() {
        return this._ProgrammaticUpdate;
    }

    public void setActive(boolean active) {
        if (active) {
            this.forceLayout();
        }
        super.setActive(active);
    }

    public void setDirty(boolean dirty) {
        boolean dirtyStateChanged = this.isDirty() ^ dirty;
        this._Dirty = dirty;
        if (dirtyStateChanged) {
            this.forceLayout();
        }
    }

    public final void setDirtyInternal(boolean dirty) {
        boolean dirtyStateChanged = this.isDirty() ^ dirty;
        if (this.isProgrammaticUpdate() && dirtyStateChanged && dirty) {
            return;
        }
        this.setDirty(dirty);
        if (dirtyStateChanged) {
            this.getEditor().editorDirtyStateChanged();
        }
    }

    public void setImage(Image image) {
        this._Image = image;
    }

    public void setInfoText(String infoText) {
        this._InfoText = infoText;
        InfoBar infoBar = this.getInfoBar();
        if (infoBar != null) {
            infoBar.setText(this._InfoText);
            this.forceLayout();
        }
    }

    public void setProgrammaticUpdate(boolean programmaticUpdate) {
        this._ProgrammaticUpdate = programmaticUpdate;
    }

    protected void contributeToToolBar(IToolBarManager toolBarManager) {
    }

    protected final Composite createClient(IManagedForm managedForm, Composite body) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite client = new Composite(body, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point superSize = super.computeSize(wHint, hHint, changed);
                return new Point(0, superSize.y);
            }
        };
        toolkit.adapt(client);
        client.setLayout(this.createClientLayout());
        return client;
    }

    protected Layout createClientLayout() {
        FormLayout clientLayout = new FormLayout();
        clientLayout.marginWidth = 8;
        clientLayout.marginHeight = 8;
        clientLayout.spacing = 8;
        return clientLayout;
    }

    protected final void createFormContent(IManagedForm managedForm) {
        this.makeActions();
        ScrolledForm form = managedForm.getForm();
        form.setText(this.getTitle());
        form.setImage(this.getImage());
        FormLayout bodyLayout = new FormLayout();
        bodyLayout.marginWidth = 0;
        bodyLayout.marginHeight = 0;
        Composite body = form.getBody();
        body.setLayout((Layout)bodyLayout);
        Dialog.applyDialogFont((Control)body);
        this._InfoBar = this.createInfoBar(body);
        this.setInfoText(this.getInfoText());
        this._Client = this.createClient(managedForm, body);
        FormData clientFormData = new FormData();
        clientFormData.top = this._InfoBar != null ? new FormAttachment((Control)this._InfoBar, 0, 1024) : new FormAttachment(0, 0);
        clientFormData.left = new FormAttachment(0, 0);
        clientFormData.right = new FormAttachment(100, 0);
        clientFormData.bottom = new FormAttachment(100, 0);
        this._Client.setLayoutData((Object)clientFormData);
        IToolBarManager toolBarManager = form.getToolBarManager();
        this.contributeToToolBar(toolBarManager);
        toolBarManager.update(true);
        if (!((DataModel)this.getModel()).isDestroyed()) {
            this.createModelFormContent(managedForm, this._Client);
            this.initFromModel();
        }
    }

    protected InfoBar createInfoBar(Composite body) {
        InfoBar infoBar = new InfoBar(body, 0);
        infoBar.setLayoutData(FILL_WIDTH_FORM_DATA);
        return infoBar;
    }

    protected abstract void createModelFormContent(IManagedForm var1, Composite var2);

    protected Section createSection(ScrolledForm form, Composite client, FormToolkit toolkit, String title) {
        return this.createSection(form, client, toolkit, title, null);
    }

    protected Section createSection(ScrolledForm form, Composite client, FormToolkit toolkit, String title, Image image) {
        return this.createSection(form, client, toolkit, title, image, 256);
    }

    protected Section createSection(final ScrolledForm form, Composite client, FormToolkit toolkit, String title, Image image, int style) {
        final Section section = toolkit.createSection(client, style);
        if (image != null) {
            final Composite titleComposite = new Composite((Composite)section, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    Point size = super.computeSize(wHint, hHint, changed);
                    size.x = section.getSize().x - 10;
                    return size;
                }
            };
            section.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    titleComposite.pack();
                    section.layout(true);
                }
            });
            FormLayout titleCompositeLayout = new FormLayout();
            titleCompositeLayout.marginWidth = 0;
            titleCompositeLayout.marginHeight = 0;
            titleCompositeLayout.spacing = 3;
            titleComposite.setLayout((Layout)titleCompositeLayout);
            Label imageLabel = new Label(titleComposite, 0);
            imageLabel.setImage(image);
            Label textLabel = new Label(titleComposite, 0);
            textLabel.setText(title);
            textLabel.setFont(section.getFont());
            textLabel.setForeground(section.getTitleBarForeground());
            FormData imageLabelFormData = new FormData();
            imageLabelFormData.top = new FormAttachment(0, 0);
            imageLabelFormData.left = new FormAttachment(0, 0);
            imageLabel.setLayoutData((Object)imageLabelFormData);
            imageLabel.pack();
            FormData textLabelFormData = new FormData();
            textLabelFormData.bottom = new FormAttachment((Control)imageLabel, 0, 0x1000000);
            textLabelFormData.left = new FormAttachment((Control)imageLabel);
            textLabel.setLayoutData((Object)textLabelFormData);
            textLabel.pack();
            titleComposite.pack();
            section.setTextClient((Control)titleComposite);
        } else {
            section.setText(title);
        }
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        return section;
    }

    protected Composite createSectionClient(Section section, FormToolkit toolkit) {
        Composite sectionClient = toolkit.createComposite((Composite)section);
        FormLayout sectionClientLayout = new FormLayout();
        sectionClientLayout.marginWidth = 8;
        sectionClientLayout.marginHeight = 2;
        sectionClientLayout.spacing = 8;
        sectionClient.setLayout((Layout)sectionClientLayout);
        section.setClient((Control)sectionClient);
        return sectionClient;
    }

    protected Section createTableSection(ScrolledForm form, Composite client, FormToolkit toolkit, String title, Image image, int sectionStyle, int tableStyle, String[] columnTitles, int[] columnAlignments) {
        Section section = this.createSection(form, client, toolkit, title, image, sectionStyle);
        Table table = toolkit.createTable((Composite)section, tableStyle);
        int i = 0;
        while (i < columnTitles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnTitles[i]);
            column.setAlignment(columnAlignments[i]);
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        section.setClient((Control)table);
        return section;
    }

    protected Section createTableSection(ScrolledForm form, Composite client, FormToolkit toolkit, String title, Image image, int tableStyle, String[] columnTitles, int[] columnAlignments) {
        return this.createTableSection(form, client, toolkit, title, image, 256, tableStyle, columnTitles, columnAlignments);
    }

    protected Section createTableSection(ScrolledForm form, Composite client, FormToolkit toolkit, String title, int tableStyle, String[] columnTitles, int[] columnAlignments) {
        return this.createTableSection(form, client, toolkit, title, null, 256, tableStyle, columnTitles, columnAlignments);
    }

    protected void forceLayout() {
        ScrolledForm form = this.getManagedForm().getForm();
        Composite body = form.getBody();
        body.layout(true);
        Composite client = this.getClient();
        if (client != null) {
            client.layout(true);
        }
    }

    protected Composite getClient() {
        return this._Client;
    }

    protected InfoBar getInfoBar() {
        return this._InfoBar;
    }

    protected final void initFromModel() {
        this.setProgrammaticUpdate(true);
        try {
            this.initFromModelInternal();
        }
        finally {
            this.setProgrammaticUpdate(false);
        }
    }

    protected abstract void initFromModelInternal();

    protected final void initTableEdit(Table table, TableEdit.CommitEditRunnable commitEditRunnable, int columnIndex) {
        new TableEdit(table, commitEditRunnable, columnIndex);
    }

    protected void initYesNoInfoBar(IManagedForm managedForm, SelectionListener yesListener) {
        SelectionAdapter noListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelFormPage.this.setInfoText(null);
            }
        };
        this.initYesNoInfoBar(managedForm, yesListener, (SelectionListener)noListener);
    }

    protected void initYesNoInfoBar(IManagedForm managedForm, SelectionListener yesListener, SelectionListener noListener) {
        InfoBar infoBar = this.getInfoBar();
        FormToolkit toolkit = managedForm.getToolkit();
        Button yesButton = toolkit.createButton((Composite)infoBar, "Yes", 8);
        if (yesListener != null) {
            yesButton.addSelectionListener(yesListener);
        }
        Button noButton = toolkit.createButton((Composite)infoBar, "No", 8);
        if (noListener != null) {
            noButton.addSelectionListener(noListener);
        }
        FormData yesButtonFormData = new FormData();
        yesButtonFormData.top = new FormAttachment(0, 0);
        yesButtonFormData.right = new FormAttachment((Control)noButton);
        yesButton.setLayoutData((Object)yesButtonFormData);
        FormData noButtonFormData = new FormData();
        noButtonFormData.top = new FormAttachment(0, 0);
        noButtonFormData.right = new FormAttachment(100, 0);
        noButton.setLayoutData((Object)noButtonFormData);
        FormData labelFormData = new FormData();
        labelFormData.top = new FormAttachment((Control)yesButton, 0, 0x1000000);
        labelFormData.left = new FormAttachment(0, 0);
        infoBar.getLabel().setLayoutData((Object)labelFormData);
    }

    protected void makeActions() {
    }

    protected void modelDataChanged(GenericDataModelEvent event) {
        this.modelModifiedExternally();
    }

    protected void modelDataRefreshed(GenericDataModelEvent event) {
        this.modelModifiedExternally();
    }

    protected void modelDestroyed(GenericDataModelEvent event) {
    }

    protected void modelModifiedExternally() {
        if (!((DataModel)this.getModel()).isDestroyed()) {
            this.initFromModel();
        }
    }

    protected void packTable(Table table, int[] columnWidths) {
        if (table == null) {
            return;
        }
        table.pack();
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            int columnWidth = columnWidths[i];
            if (columnWidth == -1) {
                columns[i].pack();
            } else {
                columns[i].setWidth(columnWidth);
            }
            ++i;
        }
    }

    protected void saveCompleted() {
        this.setDirty(false);
    }
}

