/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.editors;

import com.fusesource.zk.core.actions.BaseDeleteAction;
import com.fusesource.zk.core.editors.DataModelTableEditorInput;
import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.viewers.IElementType;
import com.fusesource.zk.core.viewers.ViewerFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class DataModelTableEditor<M extends DataModel<M, ?, ?>>
extends EditorPart {
    public static final int DEFAULT_TABLE_STYLE = 66306;
    private final Class<M> _ModelClass;
    private IElementType _ModelElementType;
    private TableViewer _TableViewer;

    public DataModelTableEditor(Class<M> modelClass, IElementType modelElementType) {
        this._ModelClass = modelClass;
        this._ModelElementType = modelElementType;
    }

    public final void createPartControl(Composite parent) {
        Table table = this.createTable(parent);
        this.configureTable(table);
        this._TableViewer = this.createTableViewer(table);
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this._TableViewer);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public final DataModelTableEditorInput<M> getDataModelTableEditorInput() {
        return (DataModelTableEditorInput)this.getEditorInput();
    }

    public final Class<M> getModelClass() {
        return this._ModelClass;
    }

    public final TableViewer getTableViewer() {
        return this._TableViewer;
    }

    public final void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.init(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this._TableViewer.getTable().setFocus();
    }

    protected void configureTable(Table table) {
    }

    protected Table createTable(Composite parent) {
        return new Table(parent, 66306);
    }

    protected TableViewer createTableViewer(Table table) {
        DataModelTableEditorInput<M> dataModelTableEditorInput = this.getDataModelTableEditorInput();
        return ViewerFactory.createDataModelTableViewer(this.getSite(), table, this.getModelClass(), this.getModelElementType(), dataModelTableEditorInput.getTableViewerInput(), dataModelTableEditorInput.getTableViewerInputElementType());
    }

    protected BaseDeleteAction getDeleteAction() {
        return null;
    }

    protected final IElementType getModelElementType() {
        return this._ModelElementType;
    }

    protected void init(IEditorInput input) throws PartInitException {
        if (!(input instanceof DataModelTableEditorInput)) {
            throw new PartInitException("Invalid Input: Must be " + DataModelTableEditorInput.class.getName());
        }
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getName());
    }
}

