/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.editors;

import com.fusesource.zk.core.editors.DataModelFormEditor;
import com.fusesource.zk.core.editors.DataModelFormPage;
import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.viewers.IElementType;
import com.fusesource.zk.core.viewers.ViewerFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class DataModelTableFormPage<M extends DataModel<M, ?, ?>>
extends DataModelFormPage<M> {
    public static final int DEFAULT_TABLE_STYLE = 66306;
    public static final FormData TABLE_FORM_DATA = new FormData();
    private final Class<?> _TableModelClass;
    private final IElementType _TableModelElementType;
    private TableViewer _TableViewer;
    private final Object _TableViewerInput;
    private final IElementType _TableViewerInputElementType;

    static {
        DataModelTableFormPage.TABLE_FORM_DATA.top = new FormAttachment(0, 0);
        DataModelTableFormPage.TABLE_FORM_DATA.left = new FormAttachment(0, 0);
        DataModelTableFormPage.TABLE_FORM_DATA.bottom = new FormAttachment(100, 0);
        DataModelTableFormPage.TABLE_FORM_DATA.right = new FormAttachment(100, 0);
    }

    public DataModelTableFormPage(DataModelFormEditor<M> editor, String id, String title, Class<?> tableModelClass, IElementType tableModelElementType, Object tableViewerInput, IElementType tableViewerInputElementType) {
        super(editor, id, title);
        this._TableModelClass = tableModelClass;
        this._TableModelElementType = tableModelElementType;
        this._TableViewerInput = tableViewerInput;
        this._TableViewerInputElementType = tableViewerInputElementType;
    }

    public final Class<?> getTableModelClass() {
        return this._TableModelClass;
    }

    public final IElementType getTableModelElementType() {
        return this._TableModelElementType;
    }

    public final TableViewer getTableViewer() {
        return this._TableViewer;
    }

    public final Object getTableViewerInput() {
        return this._TableViewerInput;
    }

    public final IElementType getTableViewerInputElementType() {
        return this._TableViewerInputElementType;
    }

    protected void configureTable(Table table) {
    }

    @Override
    protected void createModelFormContent(IManagedForm managedForm, Composite client) {
        Table table = this.createTable(client);
        this.configureTable(table);
        table.setLayoutData((Object)this.getTableFormData());
        this._TableViewer = this.createTableViewer(table);
    }

    protected Table createTable(Composite client) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        return toolkit.createTable(client, 66306);
    }

    protected TableViewer createTableViewer(Table table) {
        return ViewerFactory.createDataModelTableViewer(this.getSite(), table, this.getTableModelClass(), this.getTableModelElementType(), this.getTableViewerInput(), this.getTableViewerInputElementType());
    }

    protected FormData getTableFormData() {
        return TABLE_FORM_DATA;
    }

    protected int getTableStyle() {
        return 66306;
    }

    @Override
    protected void initFromModelInternal() {
    }
}

