/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.model;

import com.fusesource.zk.core.data.AbstractConnectionDescriptor;
import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.DataModelSource;
import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.core.runtime.ConnectionDescriptorFiles;
import java.util.Set;

public abstract class AbstractConnectionModelSource<M extends DataModel<M, K, D>, K extends AbstractConnectionDescriptor<K>, D>
extends DataModelSource<M, K, D> {
    private final ConnectionDescriptorFiles<K> _Files;

    public AbstractConnectionModelSource(ConnectionDescriptorFiles<K> files) {
        this._Files = files;
    }

    @Override
    public void deleteData(K descriptor) throws DataModelSourceException {
        if (!this.getFiles().delete(descriptor)) {
            throw new DataModelSourceException("Failed to delete descriptor '" + ((AbstractConnectionDescriptor)descriptor).getName() + "'");
        }
    }

    public ConnectionDescriptorFiles<K> getFiles() {
        return this._Files;
    }

    @Override
    public Set<K> getKeys() throws DataModelSourceException {
        return this.getFiles().loadAll();
    }

    @Override
    public K insertData(K key, D data) throws DataModelSourceException {
        this.getFiles().save(key);
        return key;
    }

    @Override
    public boolean isDeleteDataSupported() {
        return true;
    }

    @Override
    public boolean isGetKeysSupported() {
        return true;
    }

    @Override
    public boolean isInsertDataSupported() {
        return true;
    }

    @Override
    public boolean isUpdateDataSupported() {
        return true;
    }

    @Override
    public void updateData(M model) throws DataModelSourceException {
        this.getFiles().save((AbstractConnectionDescriptor)((DataModel)model).getKey());
    }
}

