/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.model;

import com.fusesource.zk.core.model.DataModelEvent;
import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.core.model.GenericDataModelEvent;
import com.fusesource.zk.core.model.IDataModelEventListener;
import com.fusesource.zk.core.model.IDataModelSource;
import com.fusesource.zk.core.model.IGenericDataModelEventListener;
import java.util.EventListener;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class DataModel<T extends DataModel<T, K, D>, K extends Comparable<K>, D>
implements Comparable<T> {
    private D _Data;
    private boolean _Destroyed;
    private final CopyOnWriteArrayList<IDataModelEventListener<T>> _EventListeners;
    private final CopyOnWriteArrayList<IGenericDataModelEventListener> _GenericEventListeners;
    private final GenericDataModelEvent _GenericReusableEvent;
    private final K _Key;
    private DataModelManager<T, K, D> _Manager;
    private final DataModelEvent<T> _ReusableEvent;

    public DataModel(K key) {
        this._Key = key;
        this._ReusableEvent = new DataModelEvent<T>(this.getThis());
        this._GenericReusableEvent = new GenericDataModelEvent(this.getThis());
        this._EventListeners = new CopyOnWriteArrayList();
        this._GenericEventListeners = new CopyOnWriteArrayList();
    }

    public final void addEventListener(IDataModelEventListener<T> listener) {
        if (this.isDestroyed()) {
            return;
        }
        if (!this.hasListeners()) {
            this.hookBeforeFirstListenerAdded();
        }
        if (!this._EventListeners.contains(listener)) {
            this._EventListeners.add(listener);
        }
    }

    public final void addGenericEventListener(IGenericDataModelEventListener listener) {
        if (this.isDestroyed()) {
            return;
        }
        if (!this.hasListeners()) {
            this.hookBeforeFirstListenerAdded();
        }
        if (!this._GenericEventListeners.contains(listener)) {
            this._GenericEventListeners.add(listener);
        }
    }

    @Override
    public final int compareTo(T o) {
        return this.getKey().compareTo(((DataModel)o).getKey());
    }

    public final void deleteData() throws DataModelSourceException {
        this._Manager.deleteModelData(this.getThis());
    }

    public final void updateData() throws DataModelSourceException {
        this._Manager.updateModelData(this.getThis());
    }

    public final void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        this._Destroyed = true;
        CopyOnWriteArrayList eventListeners = (CopyOnWriteArrayList)this._EventListeners.clone();
        CopyOnWriteArrayList genericEventListeners = (CopyOnWriteArrayList)this._GenericEventListeners.clone();
        this._EventListeners.clear();
        this._GenericEventListeners.clear();
        this._Manager.removeModel(this.getKey());
        for (EventListener listener : eventListeners) {
            listener.dataModelDestroyed(this._ReusableEvent);
        }
        for (EventListener listener : genericEventListeners) {
            listener.dataModelDestroyed(this._GenericReusableEvent);
        }
        this.hookAfterDestroyed();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final D getData() {
        return this._Data;
    }

    public final K getKey() {
        return this._Key;
    }

    public final DataModelManager<T, K, D> getManager() {
        return this._Manager;
    }

    public DataModel<?, ?, ?> getOwnerModel() {
        return null;
    }

    public DataModel<?, ?, ?> getParentModel() {
        return null;
    }

    public final IDataModelSource<T, K, D> getSource() {
        return this.getManager().getSource();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public boolean hasListeners() {
        return this._EventListeners.size() != 0 || this._GenericEventListeners.size() != 0;
    }

    public final boolean isDestroyed() {
        return this._Destroyed;
    }

    public final void refreshData() {
        this._Manager.refreshModelData(this.getThis());
    }

    public final void removeEventListener(IDataModelEventListener<T> listener) {
        if (this.isDestroyed()) {
            return;
        }
        if (!this._EventListeners.contains(listener)) {
            return;
        }
        this._EventListeners.remove(listener);
        if (!this.hasListeners()) {
            this.hookAfterLastListenerRemoved();
        }
    }

    public final void removeGenericEventListener(IGenericDataModelEventListener listener) {
        if (this.isDestroyed()) {
            return;
        }
        if (!this._GenericEventListeners.contains(listener)) {
            return;
        }
        this._GenericEventListeners.remove(listener);
        if (!this.hasListeners()) {
            this.hookAfterLastListenerRemoved();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + (this._Key != null ? "Key=" + this._Key + ", " : "") + (this._Data != null ? "Data=" + this._Data : "") + "]";
    }

    final void setData(D data) {
        this.hookBeforeSetData();
        this._Data = data;
        this.hookAfterSetData();
        for (IDataModelEventListener<T> iDataModelEventListener : this._EventListeners) {
            iDataModelEventListener.dataModelDataRefreshed(this._ReusableEvent);
        }
        for (IGenericDataModelEventListener iGenericDataModelEventListener : this._GenericEventListeners) {
            iGenericDataModelEventListener.dataModelDataRefreshed(this._GenericReusableEvent);
        }
    }

    final void setManager(DataModelManager<T, K, D> manager) {
        this._Manager = manager;
    }

    protected final void fireDataModelDataChanged() {
        for (IDataModelEventListener<T> iDataModelEventListener : this._EventListeners) {
            iDataModelEventListener.dataModelDataChanged(this._ReusableEvent);
        }
        for (IGenericDataModelEventListener iGenericDataModelEventListener : this._GenericEventListeners) {
            iGenericDataModelEventListener.dataModelDataChanged(this._GenericReusableEvent);
        }
    }

    protected abstract T getThis();

    protected void hookAfterDestroyed() {
    }

    protected void hookAfterLastListenerRemoved() {
        this.destroy();
    }

    protected void hookAfterSetData() {
    }

    protected void hookBeforeFirstListenerAdded() {
    }

    protected void hookBeforeSetData() {
    }
}

