/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.model;

import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.DataModelManagerEvent;
import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.core.model.GenericDataModelManagerEvent;
import com.fusesource.zk.core.model.IDataModelManagerEventListener;
import com.fusesource.zk.core.model.IDataModelSource;
import com.fusesource.zk.core.model.IGenericDataModelManagerEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DataModelManager<M extends DataModel<M, K, D>, K extends Comparable<K>, D> {
    private boolean _Destroyed;
    private CopyOnWriteArrayList<IDataModelManagerEventListener<M, K, D>> _EventListeners;
    private CopyOnWriteArrayList<IGenericDataModelManagerEventListener> _GenericEventListeners;
    private final ConcurrentHashMap<K, M> _Models;
    private final IDataModelSource<M, K, D> _Source;

    public DataModelManager(IDataModelSource<M, K, D> source) {
        this._Source = source;
        this._Models = new ConcurrentHashMap();
    }

    public void addEventListener(IDataModelManagerEventListener<M, K, D> listener) {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        if (this._EventListeners == null) {
            this._EventListeners = new CopyOnWriteArrayList();
        }
        if (!this._EventListeners.contains(listener)) {
            this._EventListeners.add(listener);
        }
    }

    public void addGenericEventListener(IGenericDataModelManagerEventListener listener) {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        if (this._GenericEventListeners == null) {
            this._GenericEventListeners = new CopyOnWriteArrayList();
        }
        if (!this._GenericEventListeners.contains(listener)) {
            this._GenericEventListeners.add(listener);
        }
    }

    public void destroy() {
        EventObject event;
        if (this.isDestroyed()) {
            return;
        }
        List<M> managedModels = this.getManagedModels();
        this._Destroyed = true;
        this._Models.clear();
        if (this._EventListeners != null) {
            event = new DataModelManagerEvent(this, null);
            for (IDataModelManagerEventListener iDataModelManagerEventListener : this._EventListeners) {
                iDataModelManagerEventListener.dataModelManagerDestroyed(event);
            }
            this._EventListeners.clear();
        }
        if (this._GenericEventListeners != null) {
            event = new GenericDataModelManagerEvent(this, null);
            for (IGenericDataModelManagerEventListener iGenericDataModelManagerEventListener : this._GenericEventListeners) {
                iGenericDataModelManagerEventListener.dataModelManagerDestroyed((GenericDataModelManagerEvent)event);
            }
            this._GenericEventListeners.clear();
        }
        for (DataModel model : managedModels) {
            model.destroy();
        }
    }

    public void destroyManagedModels() {
        if (this.isDestroyed()) {
            return;
        }
        List<M> managedModels = this.getManagedModels();
        this._Models.clear();
        for (DataModel model : managedModels) {
            model.destroy();
        }
    }

    public Set<K> findKeys(Object criteria) throws DataModelSourceException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        return this._Source.findKeys(criteria);
    }

    public List<M> findManagedModels(Object criteria) throws DataModelSourceException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        Set<K> keySet = this.findKeys(criteria);
        if (keySet == null) {
            return null;
        }
        return this.getManagedModels(keySet);
    }

    public List<M> findModels(Object criteria) throws DataModelSourceException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        Set<K> keySet = this.findKeys(criteria);
        if (keySet == null) {
            return null;
        }
        return this.getModels(keySet);
    }

    public Set<K> getKeys() throws DataModelSourceException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        return this._Source.getKeys();
    }

    public Set<K> getManagedKeys() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        return Collections.unmodifiableSet(new TreeSet(this._Models.keySet()));
    }

    public M getManagedModel(K key) {
        if (this.isManagedKey(key)) {
            return (M)((DataModel)this._Models.get(key));
        }
        return null;
    }

    public int getManagedModelCount() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        return this._Models.size();
    }

    public List<M> getManagedModels() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        Set<K> keys = this.getManagedKeys();
        ArrayList<DataModel> models = new ArrayList<DataModel>(keys.size());
        for (Comparable key : keys) {
            models.add((DataModel)this._Models.get(key));
        }
        return models;
    }

    public List<M> getManagedModels(Set<K> keySet) {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        if (keySet == null) {
            throw new IllegalArgumentException("null keys");
        }
        ArrayList<M> models = new ArrayList<M>(keySet.size());
        for (Comparable key : keySet) {
            M model = this.getManagedModel(key);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    public M getModel(K key) throws DataModelSourceException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        M model = this.getManagedModel(key);
        if (model != null) {
            return model;
        }
        model = this._Source.createModel(key);
        if (model == null) {
            return null;
        }
        if (((DataModel)model).isDestroyed()) {
            return null;
        }
        this.addModel(key, model);
        return model;
    }

    public List<M> getModels() throws DataModelSourceException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        Set<K> keySet = this.getKeys();
        return this.getModels(keySet);
    }

    public List<M> getModels(Set<K> keySet) throws DataModelSourceException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        if (keySet == null) {
            throw new IllegalArgumentException("null keys");
        }
        ArrayList<M> models = new ArrayList<M>(keySet.size());
        for (Comparable key : keySet) {
            M model = this.getModel(key);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    public IDataModelSource<M, K, D> getSource() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        return this._Source;
    }

    public void insertData(K key, D data) throws DataModelSourceException {
        this._Source.insertData(key, data);
    }

    public boolean isDestroyed() {
        return this._Destroyed;
    }

    public boolean isManagedKey(K key) {
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        return this._Models.containsKey(key);
    }

    public void refreshManagedModels() throws DataModelSourceException {
        if (this.isDestroyed()) {
            return;
        }
        List<M> managedModels = this.getManagedModels();
        for (DataModel model : managedModels) {
            this.refreshModelData(model);
        }
    }

    public void removeEventListener(IDataModelManagerEventListener<M, K, D> listener) {
        if (this.isDestroyed()) {
            return;
        }
        if (this._EventListeners == null) {
            return;
        }
        if (!this._EventListeners.contains(listener)) {
            return;
        }
        this._EventListeners.remove(listener);
    }

    public void removeGenericEventListener(IGenericDataModelManagerEventListener listener) {
        if (this.isDestroyed()) {
            return;
        }
        if (this._GenericEventListeners == null) {
            return;
        }
        if (!this._GenericEventListeners.contains(listener)) {
            return;
        }
        this._GenericEventListeners.remove(listener);
    }

    public String toString() {
        return "DataModelManager [ManagedModelCount=" + this.getManagedModelCount() + ", " + (this.getSource() != null ? "Source=" + this.getSource() + ", " : "") + "Destroyed=" + this.isDestroyed() + "]";
    }

    void deleteModelData(M model) throws DataModelSourceException {
        this.verifyIsManagedModel(model);
        this._Source.deleteData(((DataModel)model).getKey());
        ((DataModel)model).destroy();
    }

    void refreshModelData(M model) throws DataModelSourceException {
        this.verifyIsManagedModel(model);
        D data = this._Source.getData(((DataModel)model).getKey());
        if (data == null) {
            ((DataModel)model).destroy();
            return;
        }
        ((DataModel)model).setData(data);
    }

    void removeModel(K key) {
        EventObject event;
        if (key == null || !this._Models.containsKey(key)) {
            return;
        }
        DataModel model = (DataModel)this._Models.get(key);
        this._Models.remove(key);
        if (this._EventListeners != null) {
            event = new DataModelManagerEvent(this, model);
            for (IDataModelManagerEventListener iDataModelManagerEventListener : this._EventListeners) {
                iDataModelManagerEventListener.dataModelManagerDataModelRemoved(event);
            }
        }
        if (this._GenericEventListeners != null) {
            event = new GenericDataModelManagerEvent(this, model);
            for (IGenericDataModelManagerEventListener iGenericDataModelManagerEventListener : this._GenericEventListeners) {
                iGenericDataModelManagerEventListener.dataModelManagerDataModelRemoved((GenericDataModelManagerEvent)event);
            }
        }
    }

    void updateModelData(M model) throws DataModelSourceException {
        this._Source.updateData(model);
        this.refreshModelData(model);
    }

    private void addModel(K key, M model) {
        EventObject event;
        if (this.isDestroyed()) {
            throw new IllegalStateException("DataModelManager is destroyed.");
        }
        this._Models.put(key, model);
        ((DataModel)model).setManager(this);
        if (this._EventListeners != null) {
            event = new DataModelManagerEvent(this, model);
            for (IDataModelManagerEventListener iDataModelManagerEventListener : this._EventListeners) {
                iDataModelManagerEventListener.dataModelManagerDataModelAdded(event);
            }
        }
        if (this._GenericEventListeners != null) {
            event = new GenericDataModelManagerEvent(this, (DataModel<?, ?, ?>)model);
            for (IGenericDataModelManagerEventListener iGenericDataModelManagerEventListener : this._GenericEventListeners) {
                iGenericDataModelManagerEventListener.dataModelManagerDataModelAdded((GenericDataModelManagerEvent)event);
            }
        }
    }

    private void verifyIsManagedModel(M model) {
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        if (((DataModel)model).isDestroyed()) {
            throw new IllegalArgumentException("model is destroyed");
        }
        Object key = ((DataModel)model).getKey();
        if (!this._Models.containsKey(key)) {
            throw new IllegalArgumentException("model is not managed here");
        }
        if (this._Models.get(key) != model) {
            throw new IllegalArgumentException("specified model does not match the managed one for key: " + key);
        }
    }
}

