/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.model;

import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.core.model.IDataModelSource;
import com.fusesource.zk.core.model.OperationNotSupportedException;
import java.util.Set;

public abstract class DataModelSource<M extends DataModel<M, K, D>, K extends Comparable<K>, D>
implements IDataModelSource<M, K, D> {
    @Override
    public final M createModel(K key) throws DataModelSourceException {
        Set<K> keys;
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (this.isGetKeysSupported() && !(keys = this.getKeys()).contains(key)) {
            throw new IllegalArgumentException("invalid key: " + key);
        }
        Object data = this.getData(key);
        if (data == null) {
            return null;
        }
        M model = this.createModelInternal(key);
        ((DataModel)model).setData(data);
        return model;
    }

    @Override
    public void deleteData(K key) throws DataModelSourceException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Set<K> findKeys(Object criteria) throws DataModelSourceException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Set<K> getKeys() throws DataModelSourceException {
        throw new OperationNotSupportedException();
    }

    @Override
    public K insertData(K key, D data) throws DataModelSourceException {
        throw new OperationNotSupportedException();
    }

    @Override
    public boolean isDeleteDataSupported() {
        return false;
    }

    @Override
    public boolean isFindKeysSupported(Object criteria) {
        return false;
    }

    @Override
    public boolean isGetKeysSupported() {
        return false;
    }

    @Override
    public boolean isInsertDataSupported() {
        return false;
    }

    @Override
    public boolean isUpdateDataSupported() {
        return false;
    }

    @Override
    public void updateData(M model) throws DataModelSourceException {
        throw new OperationNotSupportedException();
    }

    protected abstract M createModelInternal(K var1) throws DataModelSourceException;
}

