/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DelegatingInvocationHandler
implements InvocationHandler {
    private final Object _Delegate;
    private final Map<String, Method> _DelegateMethods;

    public static String baseGetMethodKey(Method method) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(String.valueOf(method.getName()) + "(");
        Class<?>[] params = method.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            sb.append(params[i].getName());
            if (i < params.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public DelegatingInvocationHandler(Object delegate) {
        this._Delegate = delegate;
        Method[] methods = this._Delegate.getClass().getMethods();
        this._DelegateMethods = new HashMap<String, Method>(methods.length);
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            this._DelegateMethods.put(this.getMethodKey(method), method);
            ++n2;
        }
    }

    public final Object getDelegate() {
        return this._Delegate;
    }

    public final Map<String, Method> getDelegateMethods() {
        return Collections.unmodifiableMap(this._DelegateMethods);
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                Object arg = args[0];
                if (arg instanceof Proxy) {
                    return this.equals(Proxy.getInvocationHandler(arg));
                }
                return false;
            }
            if (methodName.equals("hashCode")) {
                return this.hashCode();
            }
            if (methodName.equals("toString")) {
                return this.toString();
            }
        }
        return this.subInvoke(proxy, method, args);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [" + (this._Delegate != null ? "Delegate=" + this._Delegate : "") + "]";
    }

    protected Object subInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.baseInvoke(proxy, method, args);
    }

    protected final Object baseInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodKey = this.getMethodKey(method);
        Object result = null;
        try {
            result = this._DelegateMethods.get(methodKey).invoke(this._Delegate, args);
        }
        catch (InvocationTargetException e) {
            System.err.println(e);
            e.getCause().printStackTrace();
        }
        catch (Throwable t) {
            System.err.println(t);
            t.printStackTrace();
        }
        return result;
    }

    protected IBaseInvokeRunnable createBaseInvokeRunnable(final Object proxy, final Method method, final Object[] args) {
        return new IBaseInvokeRunnable(){
            private Throwable _Error;
            private Object _Result;

            @Override
            public Throwable getError() {
                return this._Error;
            }

            @Override
            public Object getResult() {
                return this._Result;
            }

            @Override
            public void run() {
                try {
                    this._Result = DelegatingInvocationHandler.this.baseInvoke(proxy, method, args);
                }
                catch (Throwable t) {
                    this._Error = t;
                }
            }
        };
    }

    protected String getMethodKey(Method method) {
        return DelegatingInvocationHandler.baseGetMethodKey(method);
    }

    public static interface IBaseInvokeRunnable
    extends Runnable {
        public Throwable getError();

        public Object getResult();
    }
}

